/*
 * Decompiled with CFR 0.152.
 */
package com.syllient.livingchest.saveddata;

import com.syllient.livingchest.PacketHandler;
import com.syllient.livingchest.entity.ChesterEntity;
import com.syllient.livingchest.eventhandler.registry.EntityRegistry;
import com.syllient.livingchest.network.message.SyncVirtualChesterMessage;
import com.syllient.livingchest.util.NbtUtil;
import com.syllient.livingchest.util.Position;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.PacketDistributor;

public class VirtualChesterSavedData
extends WorldSavedData {
    private static final String ID = "livingchest.virtualchester";
    private static final VirtualChesterSavedData INSTANCE = new VirtualChesterSavedData();
    private static final int TICK_DEAD_TIME_STEP = 600;
    private final Map<UUID, VirtualChester> virtualChesterByPlayerId = new HashMap<UUID, VirtualChester>();
    private int tickCount = 0;

    public VirtualChesterSavedData() {
        super(ID);
    }

    public VirtualChesterSavedData(String id) {
        super(id);
    }

    public static VirtualChesterSavedData getServerInstance(World world) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("The world must be an instance of ServerWorld.");
        }
        return (VirtualChesterSavedData)((ServerWorld)world).func_73046_m().func_241755_D_().func_72863_F().func_217227_h().func_215752_a(VirtualChesterSavedData::new, ID);
    }

    public static VirtualChesterSavedData getClientInstance(World world) {
        if (!world.field_72995_K) {
            throw new IllegalArgumentException("The world must be an instance of ClientWorld.");
        }
        return INSTANCE;
    }

    public VirtualChester getVirtualChester(UUID playerId) {
        return this.virtualChesterByPlayerId.computeIfAbsent(playerId, key -> new VirtualChester());
    }

    public void spawnChester(PlayerEntity player, BlockPos pos) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        VirtualChester virtualChester = this.getVirtualChester(player.func_110124_au());
        ServerWorld world = (ServerWorld)player.field_70170_p;
        if (virtualChester.isSpawned()) {
            return;
        }
        if (virtualChester.isDead()) {
            int minutes = (int)Math.ceil((float)virtualChester.getDeadTime() / 20.0f / 60.0f);
            player.func_145747_a((ITextComponent)new StringTextComponent("Ooh, looks like your Chester is dead. You still need to wait " + TextFormatting.RED + minutes + " minute" + (minutes > 1 ? "s " : " ") + TextFormatting.WHITE + "before you can summon him again."), Util.field_240973_b_);
            return;
        }
        if (!world.func_175623_d(pos.func_177984_a())) {
            return;
        }
        ChesterEntity chesterEntity = (ChesterEntity)EntityRegistry.CHESTER.func_200721_a((World)world);
        if (virtualChester.getAdditionalSaveData() != null) {
            chesterEntity.func_70037_a(virtualChester.getAdditionalSaveData());
            virtualChester.setAdditionalSaveData(null);
        }
        virtualChester.setIsSpawned(chesterEntity.func_110124_au());
        chesterEntity.func_193101_c(player);
        chesterEntity.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
        chesterEntity.setYawRotations(player.field_70177_z - 180.0f);
        chesterEntity.setPrevYawRotations(chesterEntity.field_70177_z);
        world.func_217376_c((Entity)chesterEntity);
    }

    public void despawnChester(ChesterEntity chester) {
        if (chester.field_70170_p.field_72995_K || chester.func_184753_b() == null) {
            return;
        }
        this.despawnChester((ServerWorld)chester.field_70170_p, chester.func_184753_b());
    }

    public void despawnChester(ServerWorld world, UUID playerId) {
        VirtualChester virtualChester = this.getVirtualChester(playerId);
        if (!virtualChester.isSpawned()) {
            return;
        }
        ChesterEntity chesterEntity = (ChesterEntity)world.func_217461_a(virtualChester.getUniqueId());
        if (chesterEntity != null) {
            CompoundNBT additionalSaveData = new CompoundNBT();
            chesterEntity.setEyeBone(null);
            chesterEntity.func_213281_b(additionalSaveData);
            virtualChester.setAdditionalSaveData(additionalSaveData);
            virtualChester.setIsDespawned();
            chesterEntity.func_70106_y();
            return;
        }
        PlayerEntity player = world.func_217371_b(playerId);
        Position lastPos = virtualChester.getPosition();
        if (player != null) {
            if (lastPos == null) {
                player.func_145747_a((ITextComponent)new StringTextComponent("The last know position of your Chester has not been saved. This is probably a bug."), Util.field_240973_b_);
                return;
            }
            player.func_145747_a((ITextComponent)new StringTextComponent("You need to get closer to your Chester. Last know position:"), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + lastPos.toString()), Util.field_240973_b_);
        }
    }

    public void toggleChester(PlayerEntity player, BlockPos pos) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getVirtualChester(player.func_110124_au()).isSpawned()) {
            this.despawnChester((ServerWorld)player.field_70170_p, player.func_110124_au());
        } else {
            this.spawnChester(player, pos);
        }
    }

    private void tickDeadTime() {
        boolean wasResurrected = this.virtualChesterByPlayerId.values().stream().reduce(false, (wasResurrectedIn, virtualChester) -> {
            if (virtualChester.getDeadTime() > 0) {
                ((VirtualChester)virtualChester).setDeadTime(virtualChester.getDeadTime() - 600);
                return wasResurrectedIn != false || virtualChester.getDeadTime() <= 0;
            }
            return wasResurrectedIn;
        }, Boolean::logicalOr);
        if (wasResurrected) {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncVirtualChesterMessage());
        }
    }

    public void tickServer() {
        ++this.tickCount;
        if (this.tickCount % 600 == 0) {
            this.tickDeadTime();
        }
    }

    public void handleEyeBonePlacement(PlayerEntity player, BlockPos pos) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        VirtualChester virtualChester = this.getVirtualChester(player.func_110124_au());
        ServerWorld world = (ServerWorld)player.field_70170_p;
        if (!virtualChester.isSpawned()) {
            return;
        }
        ChesterEntity chesterEntity = (ChesterEntity)world.func_217461_a(virtualChester.getUniqueId());
        if (chesterEntity == null) {
            return;
        }
        chesterEntity.setEyeBone(pos);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "A new Eye Bone position has been set for your Chester."), Util.field_240973_b_);
    }

    public void handleChesterDataSave(ChesterEntity chester) {
        if (chester.func_184753_b() == null) {
            return;
        }
        this.getVirtualChester(chester.func_184753_b()).setPosition(chester);
    }

    public void handleChesterDeath(ChesterEntity chester) {
        if (chester.func_184753_b() == null) {
            return;
        }
        VirtualChester virtualChester = this.getVirtualChester(chester.func_184753_b());
        virtualChester.setIsDespawned();
        virtualChester.setDeadTime(chester.getDeathCooldown());
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncVirtualChesterMessage());
    }

    public CompoundNBT func_189551_b(CompoundNBT compoundIn) {
        compoundIn.func_218657_a("VirtualChesterList", (INBT)NbtUtil.serializeMap(this.virtualChesterByPlayerId, CompoundNBT::func_186854_a, (compound, key, value) -> compound.func_218657_a(key, (INBT)value.serializeNBT())));
        return compoundIn;
    }

    public void func_76184_a(CompoundNBT compoundIn) {
        if (compoundIn.func_74764_b("VirtualChesterList")) {
            this.virtualChesterByPlayerId.clear();
            this.virtualChesterByPlayerId.putAll(NbtUtil.deserializeMap(compoundIn.func_150295_c("VirtualChesterList", 10), CompoundNBT::func_186857_a, (compound, key) -> new VirtualChester(compound.func_74775_l(key))));
        }
    }

    public class VirtualChester
    implements INBTSerializable<CompoundNBT> {
        private CompoundNBT additionalSaveData = null;
        private int deadTime = 0;
        private UUID uniqueId = null;
        private Position position = null;

        public VirtualChester() {
        }

        public VirtualChester(CompoundNBT nbt) {
            this.deserializeNBT(nbt);
        }

        public boolean isDead() {
            return this.deadTime > 0;
        }

        public boolean isSpawned() {
            return this.uniqueId != null;
        }

        private void setIsSpawned(UUID uuid) {
            this.setUniqueId(uuid);
        }

        private void setIsDespawned() {
            this.setUniqueId(null);
        }

        private CompoundNBT getAdditionalSaveData() {
            return this.additionalSaveData;
        }

        private void setAdditionalSaveData(CompoundNBT compoundIn) {
            this.additionalSaveData = compoundIn;
            VirtualChesterSavedData.this.func_76185_a();
        }

        public int getDeadTime() {
            return this.deadTime;
        }

        private void setDeadTime(int deadTime) {
            this.deadTime = deadTime;
            VirtualChesterSavedData.this.func_76185_a();
        }

        public UUID getUniqueId() {
            return this.uniqueId;
        }

        private void setUniqueId(UUID uniqueId) {
            this.uniqueId = uniqueId;
            VirtualChesterSavedData.this.func_76185_a();
        }

        public Position getPosition() {
            return this.position;
        }

        private void setPosition(ChesterEntity chester) {
            this.setPosition(chester.func_226277_ct_(), chester.func_226278_cu_(), chester.func_226281_cx_(), chester.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a());
        }

        private void setPosition(double posX, double posY, double posZ, String dim) {
            if (this.position == null) {
                this.position = new Position(posX, posY, posZ, dim);
            } else {
                this.position.setPosition(posX, posY, posZ, dim);
            }
            VirtualChesterSavedData.this.func_76185_a();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT compound = new CompoundNBT();
            if (this.additionalSaveData != null) {
                compound.func_218657_a("AdditionalSaveData", (INBT)this.additionalSaveData);
            }
            if (this.deadTime > 0) {
                compound.func_74768_a("DeadTime", this.deadTime);
            }
            if (this.uniqueId != null) {
                compound.func_186854_a("UniqueId", this.uniqueId);
            }
            if (this.position != null) {
                compound.func_218657_a("Position", (INBT)this.position.serializeNBT());
            }
            return compound;
        }

        public void deserializeNBT(CompoundNBT compoundIn) {
            if (compoundIn.func_74764_b("AdditionalSaveData")) {
                this.additionalSaveData = compoundIn.func_74775_l("AdditionalSaveData");
            }
            if (compoundIn.func_74764_b("DeadTime")) {
                this.deadTime = compoundIn.func_74762_e("DeadTime");
            }
            if (compoundIn.func_186855_b("UniqueId")) {
                this.uniqueId = compoundIn.func_186857_a("UniqueId");
            }
            if (compoundIn.func_74764_b("Position")) {
                this.position = new Position(compoundIn.func_74775_l("Position"));
            }
        }

        class NbtKey {
            public static final String ADDITIONAL_SAVE_DATA = "AdditionalSaveData";
            public static final String DEAD_TIME = "DeadTime";
            public static final String UNIQUE_ID = "UniqueId";
            public static final String POSITION = "Position";

            NbtKey() {
            }
        }
    }

    class NbtKey {
        public static final String VIRTUAL_CHESTER_LIST = "VirtualChesterList";

        NbtKey() {
        }
    }
}

