/*
 * Decompiled with CFR 0.152.
 */
package com.syllient.livingchest.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import org.apache.logging.log4j.util.TriConsumer;

public class NbtUtil {
    public static <K, V> ListNBT serializeMap(Map<K, V> map, TriConsumer<CompoundNBT, String, K> keySetter, TriConsumer<CompoundNBT, String, V> valueSetter) {
        ListNBT list = new ListNBT();
        map.forEach((key, value) -> {
            CompoundNBT compound = new CompoundNBT();
            keySetter.accept((Object)compound, (Object)"Key", key);
            valueSetter.accept((Object)compound, (Object)"Value", value);
            list.add((Object)compound);
        });
        return list;
    }

    public static <K, V> HashMap<K, V> deserializeMap(ListNBT list, BiFunction<CompoundNBT, String, K> keyGetter, BiFunction<CompoundNBT, String, V> valueGetter) {
        HashMap map = new HashMap();
        list.forEach(nbt -> {
            CompoundNBT compound = (CompoundNBT)nbt;
            map.put(keyGetter.apply(compound, "Key"), valueGetter.apply(compound, "Value"));
        });
        return map;
    }

    class NbtKey {
        public static final String KEY = "Key";
        public static final String VALUE = "Value";

        NbtKey() {
        }
    }
}

