/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.entity.SeatEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernChairBlock
extends FurnitureHorizontalWaterloggedBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ModernChairBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BACKREST = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.1, (double)9.5, (double)11.5, (double)13.9, (double)19.5, (double)13.0), (Direction)Direction.NORTH));
        VoxelShape[] SEAT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.1, (double)8.0, (double)3.0, (double)13.9, (double)9.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] FRONT_BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)8.0, (double)3.5), (Direction)Direction.NORTH));
        VoxelShape[] LEFT_BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)6.5, (double)12.5, (double)14.0, (double)8.0, (double)14.0), (Direction)Direction.WEST));
        VoxelShape[] RIGHT_BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)6.5, (double)12.5, (double)13.0, (double)8.0, (double)14.0), (Direction)Direction.EAST));
        VoxelShape[] BACK_BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)6.5, (double)11.5, (double)14.0, (double)8.0, (double)13.0), (Direction)Direction.NORTH));
        VoxelShape[] FRONT_LEFT_LEG = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)12.5, (double)3.5, (double)8.0, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] FRONT_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)12.5, (double)0.0, (double)12.5, (double)14.0, (double)8.0, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_SUPPORT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)12.5, (double)14.0, (double)1.5, (double)14.0), (Direction)Direction.WEST));
        VoxelShape[] RIGHT_SUPPORT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)12.5, (double)14.0, (double)1.5, (double)14.0), (Direction)Direction.EAST));
        VoxelShape[] BACK_SUPPORT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)12.5, (double)14.0, (double)1.5, (double)14.0), (Direction)Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(BACKREST[direction.m_122416_()]);
            shapes.add(SEAT[direction.m_122416_()]);
            shapes.add(FRONT_BASE[direction.m_122416_()]);
            shapes.add(BACK_BASE[direction.m_122416_()]);
            shapes.add(LEFT_BASE[direction.m_122416_()]);
            shapes.add(RIGHT_BASE[direction.m_122416_()]);
            shapes.add(FRONT_LEFT_LEG[direction.m_122416_()]);
            shapes.add(FRONT_RIGHT_LEG[direction.m_122416_()]);
            shapes.add(LEFT_SUPPORT[direction.m_122416_()]);
            shapes.add(RIGHT_SUPPORT[direction.m_122416_()]);
            shapes.add(BACK_SUPPORT[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return SeatEntity.create((Level)level, (BlockPos)pos, (double)0.4, (Player)player, (Direction)((Direction)state.m_61143_((Property)DIRECTION)));
    }
}

