/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureWaterloggedBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernCoffeeTableBlock
extends FurnitureWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty TALL = BooleanProperty.m_61465_((String)"tall");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ModernCoffeeTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TALL, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape TABLE_TOP_SHORT = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape TABLE_TOP_TALL = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape LEG_SOUTH_EAST_TALL = Block.m_49796_((double)13.5, (double)0.0, (double)13.5, (double)15.0, (double)14.0, (double)15.0);
        VoxelShape LEG_SOUTH_WEST_TALL = Block.m_49796_((double)1.0, (double)0.0, (double)13.5, (double)2.5, (double)14.0, (double)15.0);
        VoxelShape LEG_NORTH_WEST_TALL = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)2.5, (double)14.0, (double)2.5);
        VoxelShape LEG_NORTH_EAST_TALL = Block.m_49796_((double)13.5, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)2.5);
        VoxelShape LEG_SOUTH_EAST_SHORT = Block.m_49796_((double)13.5, (double)0.0, (double)13.5, (double)15.0, (double)6.0, (double)15.0);
        VoxelShape LEG_SOUTH_WEST_SHORT = Block.m_49796_((double)1.0, (double)0.0, (double)13.5, (double)2.5, (double)6.0, (double)15.0);
        VoxelShape LEG_NORTH_WEST_SHORT = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)2.5, (double)6.0, (double)2.5);
        VoxelShape LEG_NORTH_EAST_SHORT = Block.m_49796_((double)13.5, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)2.5);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean tall = (Boolean)state.m_61143_((Property)TALL);
            boolean north = (Boolean)state.m_61143_((Property)NORTH);
            boolean east = (Boolean)state.m_61143_((Property)EAST);
            boolean south = (Boolean)state.m_61143_((Property)SOUTH);
            boolean west = (Boolean)state.m_61143_((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(tall ? TABLE_TOP_TALL : TABLE_TOP_SHORT);
            if (!north && !west) {
                shapes.add(tall ? LEG_NORTH_WEST_TALL : LEG_NORTH_WEST_SHORT);
            }
            if (!north && !east) {
                shapes.add(tall ? LEG_NORTH_EAST_TALL : LEG_NORTH_EAST_SHORT);
            }
            if (!south && !west) {
                shapes.add(tall ? LEG_SOUTH_WEST_TALL : LEG_SOUTH_WEST_SHORT);
            }
            if (!south && !east) {
                shapes.add(tall ? LEG_SOUTH_EAST_TALL : LEG_SOUTH_EAST_SHORT);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean tall = (Boolean)state.m_61143_((Property)TALL);
        boolean north = this.isCoffeeTable(level, pos, Direction.NORTH, tall);
        boolean east = this.isCoffeeTable(level, pos, Direction.EAST, tall);
        boolean south = this.isCoffeeTable(level, pos, Direction.SOUTH, tall);
        boolean west = this.isCoffeeTable(level, pos, Direction.WEST, tall);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean isCoffeeTable(LevelAccessor level, BlockPos source, Direction direction, boolean tall) {
        BlockState state = level.m_8055_(source.m_142300_(direction));
        return state.m_60734_() == this && (Boolean)state.m_61143_((Property)TALL) == tall;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        if (state.m_60734_() == this) {
            return (BlockState)state.m_61124_((Property)TALL, (Comparable)Boolean.valueOf(true));
        }
        return super.m_5573_(context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        return (Boolean)state.m_61143_((Property)TALL) == false && stack.m_41720_() == this.m_5456_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH});
        builder.m_61104_(new Property[]{EAST});
        builder.m_61104_(new Property[]{SOUTH});
        builder.m_61104_(new Property[]{WEST});
        builder.m_61104_(new Property[]{TALL});
    }
}

