/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.nosiphus.furniture.client.event.CreativeScreenEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class TagButton
extends Button {
    private static final ResourceLocation TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private CreativeScreenEvents.TagFilter category;
    private ItemStack stack;
    private boolean toggled;

    public TagButton(int x, int y, CreativeScreenEvents.TagFilter category, Button.OnPress onPress) {
        super(x, y, 32, 28, TextComponent.f_131282_, onPress);
        this.category = category;
        this.stack = category.getIcon();
        this.toggled = category.isEnabled();
    }

    public CreativeScreenEvents.TagFilter getCategory() {
        return this.category;
    }

    public void m_5691_() {
        this.toggled = !this.toggled;
        this.category.setEnabled(this.toggled);
        super.m_5691_();
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TABS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int width = this.toggled ? 32 : 28;
        int textureX = 28;
        int textureY = this.toggled ? 32 : 0;
        this.drawRotatedTexture(poseStack.m_85850_().m_85861_(), this.f_93620_, this.f_93621_, textureX, textureY, width, 28);
        ItemRenderer renderer = minecraft.m_91291_();
        renderer.f_115093_ = 100.0f;
        renderer.m_115203_(this.stack, this.f_93620_ + 8, this.f_93621_ + 6);
        renderer.m_115169_(minecraft.f_91062_, this.stack, this.f_93620_ + 8, this.f_93621_ + 6);
        renderer.f_115093_ = 0.0f;
    }

    private void drawRotatedTexture(Matrix4f matrix4f, int x, int y, int textureX, int textureY, int width, int height) {
        float scaleX = 0.00390625f;
        float scaleY = 0.00390625f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix4f, (float)x, (float)(y + height), 0.0f).m_7421_((float)(textureX + height) * scaleX, (float)textureY * scaleY).m_5752_();
        buffer.m_85982_(matrix4f, (float)(x + width), (float)(y + height), 0.0f).m_7421_((float)(textureX + height) * scaleX, (float)(textureY + width) * scaleY).m_5752_();
        buffer.m_85982_(matrix4f, (float)(x + width), (float)y, 0.0f).m_7421_((float)textureX * scaleX, (float)(textureY + width) * scaleY).m_5752_();
        buffer.m_85982_(matrix4f, (float)x, (float)y, 0.0f).m_7421_((float)textureX * scaleX, (float)textureY * scaleY).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
    }

    public void updateState() {
        this.toggled = this.category.isEnabled();
    }
}

