/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.oreCreeper.ato.entities;

import com.cozary.oreCreeper.ato.util.ConfigurationHandlerATO;
import com.cozary.oreCreeper.ato.util.ExplosionTypesAto;
import com.cozary.oreCreeper.particles.ParticleList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import net.allthemods.alltheores.blocks.BlockList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class OsmiumCreeperEntity
extends MonsterEntity
implements IChargeableMob {
    private static final DataParameter<Integer> DATA_SWELL_DIR = EntityDataManager.func_187226_a(OsmiumCreeperEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_IS_POWERED = EntityDataManager.func_187226_a(OsmiumCreeperEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_IS_IGNITED = EntityDataManager.func_187226_a(OsmiumCreeperEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;

    public OsmiumCreeperEntity(EntityType<? extends MonsterEntity> p_i48553_1_, World p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
    }

    public static boolean canOreCreeperSpawn(EntityType<? extends OsmiumCreeperEntity> creeper, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return pos.func_177956_o() < (Integer)ConfigurationHandlerATO.SPAWN_ATO.osmiumCreeperMaxSpawnYLevel.get() && world.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150348_b) && OsmiumCreeperEntity.func_223323_a((IServerWorld)world, (BlockPos)pos, (Random)random) && OsmiumCreeperEntity.func_223315_a(creeper, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    private void explodeCreeper() {
        BlockState block = ((Block)BlockList.OSMIUM_BLOCK.get()).func_176223_P();
        BlockState ore = ((Block)BlockList.OSMIUM_ORE.get()).func_176223_P();
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70729_aU = true;
            new ExplosionTypesAto().osmiumExplosionEffect((Entity)this, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ore, block);
            ((ServerWorld)this.func_130014_f_()).func_195598_a((IParticleData)ParticleList.OSMIUM_EXPLOSION.get(), this.func_226277_ct_() + 0.5, this.func_226278_cu_(), this.func_226281_cx_() + 0.5, 500, d1, d2, d0, 0.5);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwellGoalCustom(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, OcelotEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, CatEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected boolean func_225511_J_() {
        return false;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        boolean flag = super.func_225503_b_(p_225503_1_, p_225503_2_);
        this.swell = (int)((float)this.swell + p_225503_1_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_SWELL_DIR, (Object)-1);
        this.field_70180_af.func_187214_a(DATA_IS_POWERED, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_IGNITED, (Object)false);
    }

    public void func_213281_b(@NotNull CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        if (((Boolean)this.field_70180_af.func_187225_a(DATA_IS_POWERED)).booleanValue()) {
            p_213281_1_.func_74757_a("powered", true);
        }
        p_213281_1_.func_74777_a("Fuse", (short)this.maxSwell);
        p_213281_1_.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        p_213281_1_.func_74757_a("ignited", this.isIgnited());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_70180_af.func_187227_b(DATA_IS_POWERED, (Object)p_70037_1_.func_74767_n("powered"));
        if (p_70037_1_.func_150297_b("Fuse", 99)) {
            this.maxSwell = p_70037_1_.func_74765_d("Fuse");
        }
        if (p_70037_1_.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = p_70037_1_.func_74771_c("ExplosionRadius");
        }
        if (p_70037_1_.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.func_70071_h_();
    }

    protected SoundEvent func_184601_bQ(@NotNull DamageSource p_32309_) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    protected void func_213333_a(@NotNull DamageSource p_32292_, int p_32293_, boolean p_32294_) {
        super.func_213333_a(p_32292_, p_32293_, p_32294_);
        Entity entity = p_32292_.func_76346_g();
        OsmiumCreeperEntity creeper = (OsmiumCreeperEntity)entity;
        if (entity != this && entity != null && creeper.canDropMobsSkull()) {
            creeper.increaseDroppedSkulls();
            this.func_199703_a((IItemProvider)Items.field_196185_dy);
        }
    }

    public boolean func_70652_k(@NotNull Entity p_32281_) {
        return true;
    }

    public boolean func_225509_J__() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_POWERED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSwelling(float p_70831_1_) {
        return MathHelper.func_219799_g((float)p_70831_1_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.field_70180_af.func_187227_b(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public void func_241841_a(@NotNull ServerWorld p_241841_1_, @NotNull LightningBoltEntity p_241841_2_) {
        super.func_241841_a(p_241841_1_, p_241841_2_);
        this.field_70180_af.func_187227_b(DATA_IS_POWERED, (Object)true);
    }

    @NotNull
    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, @NotNull Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(p_230254_1_, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                itemstack.func_222118_a(1, (LivingEntity)p_230254_1_, p_213625_1_ -> p_213625_1_.func_213334_d(p_230254_2_));
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    private void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(DATA_IS_IGNITED, (Object)true);
    }

    public boolean canDropMobsSkull() {
        return this.func_225509_J__() && this.droppedSkulls < 1;
    }

    public void increaseDroppedSkulls() {
        ++this.droppedSkulls;
    }

    public static class SwellGoalCustom
    extends Goal {
        private final OsmiumCreeperEntity creeper;
        private LivingEntity target;

        public SwellGoalCustom(OsmiumCreeperEntity p_25919_) {
            this.creeper = p_25919_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.creeper.func_70638_az();
            return this.creeper.getSwellDir() > 0 || livingentity != null && this.creeper.func_70068_e((Entity)livingentity) < 9.0;
        }

        public void func_75249_e() {
            this.creeper.func_70661_as().func_75499_g();
            this.target = this.creeper.func_70638_az();
        }

        public void func_75251_c() {
            this.target = null;
        }

        public void func_75246_d() {
            if (this.target == null) {
                this.creeper.setSwellDir(-1);
            } else if (this.creeper.func_70068_e((Entity)this.target) > 49.0) {
                this.creeper.setSwellDir(-1);
            } else if (!this.creeper.func_70635_at().func_75522_a((Entity)this.target)) {
                this.creeper.setSwellDir(-1);
            } else {
                this.creeper.setSwellDir(1);
            }
        }
    }
}

