/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.util.NameUtils;

public class ExtendedShapelessRecipeBuilder {
    private final IRecipeSerializer<?> serializer;
    private final Collection<Consumer<JsonObject>> extraData = new ArrayList<Consumer<JsonObject>>();
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private boolean hasAdvancementCriterion = false;
    private String group = "";

    protected ExtendedShapelessRecipeBuilder(IRecipeSerializer<?> serializer, IItemProvider result, int count) {
        this.serializer = serializer;
        this.result = result.func_199767_j();
        this.count = count;
    }

    public static ExtendedShapelessRecipeBuilder builder(IRecipeSerializer<?> serializer, IItemProvider result) {
        return ExtendedShapelessRecipeBuilder.builder(serializer, result, 1);
    }

    public static ExtendedShapelessRecipeBuilder builder(IRecipeSerializer<?> serializer, IItemProvider result, int count) {
        return new ExtendedShapelessRecipeBuilder(serializer, result, count);
    }

    public static ExtendedShapelessRecipeBuilder vanillaBuilder(IItemProvider result) {
        return ExtendedShapelessRecipeBuilder.vanillaBuilder(result, 1);
    }

    public static ExtendedShapelessRecipeBuilder vanillaBuilder(IItemProvider result, int count) {
        return new ExtendedShapelessRecipeBuilder(IRecipeSerializer.field_222158_b, result, count);
    }

    protected void serializeExtra(JsonObject json) {
        this.extraData.forEach(consumer -> consumer.accept(json));
    }

    public ExtendedShapelessRecipeBuilder addExtraData(Consumer<JsonObject> extraDataIn) {
        this.extraData.add(extraDataIn);
        return this;
    }

    public ExtendedShapelessRecipeBuilder addIngredient(ITag<Item> tag) {
        return this.addIngredient(tag, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(ITag<Item> tag, int quantity) {
        return this.addIngredient(Ingredient.func_199805_a(tag), quantity);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(IItemProvider item) {
        return this.addIngredient(item, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(IItemProvider item, int quantity) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), quantity);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ExtendedShapelessRecipeBuilder addCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        this.hasAdvancementCriterion = true;
        return this;
    }

    public ExtendedShapelessRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, NameUtils.from(this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.hasAdvancementCriterion && !this.advancementBuilder.func_200277_c().isEmpty()) {
            this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        ResourceLocation advancementId = new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a());
        consumer.accept(new Result(id, this, advancementId));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final ExtendedShapelessRecipeBuilder builder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, ExtendedShapelessRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = id;
            this.builder = builder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.builder.group.isEmpty()) {
                json.addProperty("group", this.builder.group);
            }
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : this.builder.ingredients) {
                ingredients.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.from(this.builder.result).toString());
            if (this.builder.count > 1) {
                result.addProperty("count", (Number)this.builder.count);
            }
            json.add("result", (JsonElement)result);
            this.builder.serializeExtra(json);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.builder.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.builder.hasAdvancementCriterion ? this.builder.advancementBuilder.func_200273_b() : null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.builder.hasAdvancementCriterion ? this.advancementId : null;
        }
    }
}

