/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.torchbandolier.crafting.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.torchbandolier.init.ModItems;
import net.silentchaos512.torchbandolier.init.ModRecipes;
import net.silentchaos512.torchbandolier.item.TorchBandolierItem;

public final class ExtractTorchesRecipe
extends CustomRecipe {
    public ExtractTorchesRecipe(ResourceLocation id) {
        super(id);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.EXTRACT_TORCHES.get();
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        StackList list = StackList.from((Container)inv);
        if (list.size() != 1) {
            return false;
        }
        ItemStack stack = list.uniqueMatch(s -> s.m_41720_() instanceof TorchBandolierItem && ((TorchBandolierItem)s.m_41720_()).getTorchBlock() != null);
        return !stack.m_41619_();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack stack = StackList.from((Container)inv).uniqueOfType(TorchBandolierItem.class);
        TorchBandolierItem item = (TorchBandolierItem)stack.m_41720_();
        Block block = item.getTorchBlock();
        int torchCount = TorchBandolierItem.getTorchCount(stack);
        int extractCount = Math.min(torchCount, 64);
        return new ItemStack((ItemLike)block, extractCount);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (item.m_41720_() instanceof TorchBandolierItem) {
                ItemStack newBandolier;
                ItemStack torches = this.assemble(inv);
                int newTorchCount = TorchBandolierItem.getTorchCount(item) - torches.m_41613_();
                if (newTorchCount > 0) {
                    newBandolier = TorchBandolierItem.createStack((TorchBandolierItem)item.m_41720_(), newTorchCount);
                    TorchBandolierItem.setTorchCount(newBandolier, newTorchCount);
                    TorchBandolierItem.setAutoFill(newBandolier, false);
                } else {
                    newBandolier = new ItemStack(ModItems.EMPTY_TORCH_BANDOLIER);
                }
                list.set(i, (Object)newBandolier);
                continue;
            }
            if (!item.hasContainerItem()) continue;
            list.set(i, (Object)item.getContainerItem());
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 1;
    }
}

