/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.torchbandolier.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.silentchaos512.lib.item.FakeItemUseContext;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.torchbandolier.TorchBandolier;
import net.silentchaos512.torchbandolier.config.Config;
import net.silentchaos512.torchbandolier.init.ModItems;
import net.silentchaos512.utils.Lazy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TorchBandolierItem
extends Item {
    private static final String NBT_ROOT = "TorchBandolier";
    private static final String NBT_AUTO_FILL = "AutoFill";
    private static final String NBT_COUNT = "Count";
    private static final int ABSORB_DELAY = 20;
    private final Lazy<Block> torchBlock;

    public TorchBandolierItem(@Nullable Block torchBlock) {
        this(() -> torchBlock);
    }

    public TorchBandolierItem(Supplier<Block> torchBlock) {
        super(new Item.Properties().m_41487_(1).setNoRepair().m_41491_(TorchBandolier.ITEM_GROUP));
        this.torchBlock = Lazy.of(torchBlock);
    }

    @Nullable
    public Block getTorchBlock() {
        return (Block)this.torchBlock.get();
    }

    public static ItemStack createStack(TorchBandolierItem item, int torchCount) {
        ItemStack result = new ItemStack((ItemLike)item);
        TorchBandolierItem.setTorchCount(result, torchCount);
        TorchBandolierItem.setAutoFill(result, true);
        return result;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_ && worldIn.m_46467_() % 20L == 0L && entityIn instanceof Player && TorchBandolierItem.isAutoFillOn(stack)) {
            this.absorbTorches(stack, (Player)entityIn);
        }
    }

    private void absorbTorches(ItemStack stack, Player player) {
        int maxTorches = TorchBandolierItem.getMaxTorchCount(stack);
        Block torch = this.getTorchBlock();
        if (torch == null || torch instanceof AirBlock || TorchBandolierItem.getTorchCount(stack) >= maxTorches) {
            return;
        }
        Item itemTorch = torch.m_5456_();
        for (ItemStack invStack : PlayerUtils.getNonEmptyStacks((Player)player, (boolean)true, (boolean)true, (boolean)false)) {
            if (invStack.m_41720_() != itemTorch) continue;
            int current = TorchBandolierItem.getTorchCount(stack);
            if (current + invStack.m_41613_() > maxTorches) {
                TorchBandolierItem.setTorchCount(stack, maxTorches);
                invStack.m_41774_(maxTorches - current);
            } else {
                TorchBandolierItem.setTorchCount(stack, current + invStack.m_41613_());
                invStack.m_41764_(0);
            }
            if (invStack.m_41613_() > 0) continue;
            PlayerUtils.removeItem((Player)player, (ItemStack)invStack);
        }
    }

    public static int absorbTorchesFromItemEntity(ItemStack bandolier, ItemStack blockStack) {
        int bandolierCount = TorchBandolierItem.getTorchCount(bandolier);
        int maxTorches = TorchBandolierItem.getMaxTorchCount(bandolier);
        int blockCount = blockStack.m_41613_();
        if (bandolierCount + blockCount > maxTorches) {
            TorchBandolierItem.setTorchCount(bandolier, maxTorches);
            return maxTorches - bandolierCount;
        }
        TorchBandolierItem.setTorchCount(bandolier, bandolierCount + blockCount);
        return blockCount;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        Block torch = this.getTorchBlock();
        if (torch == null || torch instanceof AirBlock) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!playerIn.f_19853_.f_46443_ && playerIn.m_6047_()) {
            boolean mode = !TorchBandolierItem.isAutoFillOn(stack);
            TorchBandolierItem.setAutoFill(stack, mode);
            String translationKey = "item.torchbandolier.torch_bandolier.autoFill." + (mode ? "on" : "off");
            playerIn.m_5661_((Component)new TranslatableComponent(translationKey), true);
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean consumeTorch;
        Block torch = this.getTorchBlock();
        if (torch == null || torch instanceof AirBlock) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        boolean bl = consumeTorch = player == null || !player.m_150110_().f_35937_;
        if (TorchBandolierItem.getTorchCount(stack) <= 0 && consumeTorch) {
            return InteractionResult.PASS;
        }
        ItemStack fakeBlockStack = new ItemStack((ItemLike)torch);
        InteractionResult result = fakeBlockStack.m_41661_((UseOnContext)new FakeItemUseContext(context, fakeBlockStack));
        if (result.m_19077_() && consumeTorch) {
            TorchBandolierItem.setTorchCount(stack, TorchBandolierItem.getTorchCount(stack) - 1);
        }
        if (TorchBandolierItem.getTorchCount(stack) == 0 && player != null) {
            player.m_150109_().m_6836_(TorchBandolierItem.getItemSlot(player, stack), new ItemStack(ModItems.EMPTY_TORCH_BANDOLIER));
        }
        return result;
    }

    private static int getItemSlot(Player player, ItemStack stack) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack1 = player.m_150109_().m_8020_(i);
            if (stack1.m_41619_() || stack.m_41720_() != stack1.m_41720_() || !ItemStack.m_41728_((ItemStack)stack, (ItemStack)stack1)) continue;
            return i;
        }
        return -1;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (!this.m_41389_(tab) || this.getTorchBlock() instanceof AirBlock) {
            return;
        }
        items.add((Object)TorchBandolierItem.createStack(this, TorchBandolierItem.getMaxTorchCount()));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String key = "item.torchbandolier.torch_bandolier";
        Block torch = this.getTorchBlock();
        TranslatableComponent blockName = torch != null && !(torch instanceof AirBlock) ? torch.m_49954_() : new TranslatableComponent(key + ".empty");
        tooltip.add((Component)new TranslatableComponent(key + ".blockPlaced", new Object[]{blockName}));
        if (torch != null) {
            int torches = TorchBandolierItem.getTorchCount(stack);
            int maxTorches = TorchBandolierItem.getMaxTorchCount(stack);
            tooltip.add((Component)new TranslatableComponent(key + ".count", new Object[]{torches, maxTorches}));
            boolean autoFill = TorchBandolierItem.isAutoFillOn(stack);
            tooltip.add((Component)new TranslatableComponent(key + ".autoFill." + (autoFill ? "on" : "off")));
        } else {
            tooltip.add((Component)new TranslatableComponent(key + ".emptyHint").m_130940_(ChatFormatting.ITALIC));
        }
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getTorchBlock() != null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int max = TorchBandolierItem.getMaxTorchCount(stack);
        return max > 0 ? 1.0 - (double)TorchBandolierItem.getTorchCount(stack) / (double)max : 1.0;
    }

    private static CompoundTag getData(ItemStack stack) {
        return stack.m_41698_(NBT_ROOT);
    }

    public static int getTorchCount(ItemStack stack) {
        return TorchBandolierItem.getData(stack).m_128451_(NBT_COUNT);
    }

    public static void setTorchCount(ItemStack stack, int value) {
        TorchBandolierItem.getData(stack).m_128405_(NBT_COUNT, value);
    }

    public static int getMaxTorchCount() {
        return (Integer)Config.GENERAL.maxTorchCount.get();
    }

    public static int getMaxTorchCount(ItemStack stack) {
        return TorchBandolierItem.getMaxTorchCount();
    }

    public static boolean isAutoFillOn(ItemStack stack) {
        return TorchBandolierItem.getData(stack).m_128471_(NBT_AUTO_FILL);
    }

    public static void setAutoFill(ItemStack stack, boolean value) {
        TorchBandolierItem.getData(stack).m_128379_(NBT_AUTO_FILL, value);
    }
}

