/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.lib.SilentLib;

public final class ExclusionIngredient
extends Ingredient {
    private final Ingredient parent;
    private final Collection<Ingredient> exclusions = new ArrayList<Ingredient>();

    private ExclusionIngredient(Ingredient parent, Collection<Ingredient> exclusions) {
        super(Stream.of(new Ingredient.Value[0]));
        this.parent = parent;
        this.exclusions.addAll(exclusions);
    }

    public static ExclusionIngredient of(Tag<Item> tag, Ingredient ... exclusions) {
        return ExclusionIngredient.of(Ingredient.m_43911_(tag), exclusions);
    }

    public static ExclusionIngredient of(Ingredient parent, Ingredient ... exclusions) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        Collections.addAll(list, exclusions);
        return new ExclusionIngredient(parent, list);
    }

    public static ExclusionIngredient of(Tag<Item> tag, ItemLike ... exclusions) {
        return ExclusionIngredient.of(Ingredient.m_43911_(tag), exclusions);
    }

    public static ExclusionIngredient of(Ingredient parent, ItemLike ... exclusions) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        for (ItemLike item : exclusions) {
            list.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return new ExclusionIngredient(parent, list);
    }

    public ItemStack[] m_43908_() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(Arrays.asList(this.parent.m_43908_()));
        this.exclusions.forEach(ret::removeIf);
        return ret.toArray(new ItemStack[0]);
    }

    public ItemStack[] getMatchingStacksWithExclusions() {
        return this.parent.m_43908_();
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || !this.parent.test(stack)) {
            return false;
        }
        for (Ingredient ingredient : this.exclusions) {
            if (!ingredient.test(stack)) continue;
            return false;
        }
        return true;
    }

    protected void invalidate() {
    }

    public boolean isSimple() {
        return this.parent.isSimple();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.add("value", this.parent.m_43942_());
        JsonArray array = new JsonArray();
        this.exclusions.forEach(ingredient -> array.add(ingredient.m_43942_()));
        json.add("exclusions", (JsonElement)array);
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<ExclusionIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentLib.getId("exclusion");

        @Nonnull
        public ExclusionIngredient parse(@Nonnull JsonObject json) {
            Ingredient value = Ingredient.m_43917_((JsonElement)json.get("value"));
            ArrayList<Ingredient> list = new ArrayList<Ingredient>();
            for (JsonElement e : json.get("exclusions").getAsJsonArray()) {
                if (e.isJsonPrimitive()) {
                    ResourceLocation id = new ResourceLocation(e.getAsString());
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                    if (item != null) {
                        list.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
                        continue;
                    }
                    throw new JsonParseException("Unknown item: " + id);
                }
                list.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new ExclusionIngredient(value, list);
        }

        @Nonnull
        public ExclusionIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            ArrayList<Ingredient> list = new ArrayList<Ingredient>();
            int count = buffer.readByte();
            for (int i = 0; i < count; ++i) {
                list.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new ExclusionIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), list);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull ExclusionIngredient ingredient) {
            buffer.writeByte(ingredient.exclusions.size());
            for (Ingredient ing : ingredient.exclusions) {
                ing.m_43923_(buffer);
            }
            ingredient.parent.m_43923_(buffer);
        }
    }
}

