/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.network.internal;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.silentchaos512.lib.client.gui.nbt.DisplayNBTScreen;

public class DisplayNBTPacket {
    private CompoundTag nbt;
    private Component title;

    public DisplayNBTPacket() {
    }

    public DisplayNBTPacket(CompoundTag nbt, Component title) {
        this.nbt = nbt;
        this.title = title;
    }

    public static DisplayNBTPacket fromBytes(FriendlyByteBuf buffer) {
        DisplayNBTPacket packet = new DisplayNBTPacket();
        packet.nbt = buffer.m_130260_();
        packet.title = buffer.m_130238_();
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.nbt);
        buffer.m_130083_(this.title);
    }

    public static void handle(DisplayNBTPacket packet, Supplier<NetworkEvent.Context> context) {
        ClientWrapper.handle(packet);
        context.get().setPacketHandled(true);
    }

    private static class ClientWrapper {
        private ClientWrapper() {
        }

        private static void handle(DisplayNBTPacket packet) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                DisplayNBTScreen screen = new DisplayNBTScreen(packet.nbt, packet.title);
                Minecraft.m_91087_().m_91152_((Screen)screen);
            }
        }
    }
}

