/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.network.internal;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.LogicalSidedProvider;
import net.minecraftforge.fmllegacy.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SpawnEntityPacket {
    private final Entity entity;
    private final int typeId;
    private final int entityId;
    private final UUID uuid;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final byte pitch;
    private final byte yaw;
    private final byte headYaw;
    private final int velX;
    private final int velY;
    private final int velZ;
    private final FriendlyByteBuf buf;

    public SpawnEntityPacket(Entity e) {
        this.entity = e;
        this.typeId = Registry.f_122826_.m_7447_((Object)e.m_6095_());
        this.entityId = e.m_142049_();
        this.uuid = e.m_142081_();
        this.posX = e.m_20185_();
        this.posY = e.m_20186_();
        this.posZ = e.m_20189_();
        this.pitch = (byte)Mth.m_14143_((float)(e.m_146909_() * 256.0f / 360.0f));
        this.yaw = (byte)Mth.m_14143_((float)(e.m_146908_() * 256.0f / 360.0f));
        this.headYaw = (byte)(e.m_6080_() * 256.0f / 360.0f);
        Vec3 vec3d = e.m_20184_();
        double d1 = Mth.m_14008_((double)vec3d.f_82479_, (double)-3.9, (double)3.9);
        double d2 = Mth.m_14008_((double)vec3d.f_82480_, (double)-3.9, (double)3.9);
        double d3 = Mth.m_14008_((double)vec3d.f_82481_, (double)-3.9, (double)3.9);
        this.velX = (int)(d1 * 8000.0);
        this.velY = (int)(d2 * 8000.0);
        this.velZ = (int)(d3 * 8000.0);
        this.buf = null;
    }

    private SpawnEntityPacket(int typeId, int entityId, UUID uuid, double posX, double posY, double posZ, byte pitch, byte yaw, byte headYaw, int velX, int velY, int velZ, FriendlyByteBuf buf) {
        this.entity = null;
        this.typeId = typeId;
        this.entityId = entityId;
        this.uuid = uuid;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.pitch = pitch;
        this.yaw = yaw;
        this.headYaw = headYaw;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.buf = buf;
    }

    public static void encode(SpawnEntityPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.typeId);
        buf.writeInt(msg.entityId);
        buf.writeLong(msg.uuid.getMostSignificantBits());
        buf.writeLong(msg.uuid.getLeastSignificantBits());
        buf.writeDouble(msg.posX);
        buf.writeDouble(msg.posY);
        buf.writeDouble(msg.posZ);
        buf.writeByte((int)msg.pitch);
        buf.writeByte((int)msg.yaw);
        buf.writeByte((int)msg.headYaw);
        buf.writeShort(msg.velX);
        buf.writeShort(msg.velY);
        buf.writeShort(msg.velZ);
        if (msg.entity instanceof IEntityAdditionalSpawnData) {
            ((IEntityAdditionalSpawnData)msg.entity).writeSpawnData(buf);
        }
    }

    public static SpawnEntityPacket decode(FriendlyByteBuf buf) {
        return new SpawnEntityPacket(buf.m_130242_(), buf.readInt(), new UUID(buf.readLong(), buf.readLong()), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readByte(), buf.readByte(), buf.readByte(), buf.readShort(), buf.readShort(), buf.readShort(), buf);
    }

    public static void handle(SpawnEntityPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            EntityType type = (EntityType)Registry.f_122826_.m_7942_(msg.typeId);
            if (type == null) {
                throw new RuntimeException(String.format("Could not spawn entity (id %d) with unknown type at (%f, %f, %f)", msg.entityId, msg.posX, msg.posY, msg.posZ));
            }
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide());
            Entity e = world.map(arg_0 -> ((EntityType)type).m_20615_(arg_0)).orElse(null);
            if (e == null) {
                return;
            }
            e.m_20167_(msg.posX, msg.posY, msg.posZ);
            e.m_19890_(msg.posX, msg.posY, msg.posZ, (float)(msg.yaw * 360) / 256.0f, (float)(msg.pitch * 360) / 256.0f);
            e.m_5616_((float)(msg.headYaw * 360) / 256.0f);
            e.m_5618_((float)(msg.headYaw * 360) / 256.0f);
            e.m_20234_(msg.entityId);
            e.m_20084_(msg.uuid);
            world.filter(ClientLevel.class::isInstance).ifPresent(w -> ((ClientLevel)w).m_104627_(msg.entityId, e));
            e.m_6001_((double)msg.velX / 8000.0, (double)msg.velY / 8000.0, (double)msg.velZ / 8000.0);
            if (e instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)e).readSpawnData(msg.buf);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

