/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.torchbandolier.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.item.IItemSL;
import net.silentchaos512.lib.util.EntityHelper;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.PlayerHelper;
import net.silentchaos512.torchbandolier.TorchBandolier;

public class ItemTorchBandolier
extends Item
implements IItemSL {
    private static final String NBT_ROOT = "TorchBandolier";
    private static final String NBT_AUTO_FILL = "AutoFill";
    private static final String NBT_COUNT = "Count";
    private static final int ABSORB_DELAY = 20;

    public ItemTorchBandolier() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 20L == 0L && entityIn instanceof EntityPlayer && this.isAutoFillOn(stack)) {
            this.absorbTorches(stack, (EntityPlayer)entityIn);
        }
    }

    private void absorbTorches(ItemStack stack, EntityPlayer player) {
        int maxTorches = this.getMaxTorchCount(stack);
        if (this.getTorchCount(stack) >= maxTorches) {
            return;
        }
        Item itemTorch = Item.func_150898_a((Block)this.getBlockPlaced(stack));
        for (ItemStack invStack : PlayerHelper.getNonEmptyStacks((EntityPlayer)player, (boolean)true, (boolean)true, (boolean)false)) {
            if (invStack.func_77973_b() != itemTorch) continue;
            int current = this.getTorchCount(stack);
            if (current + invStack.func_190916_E() > maxTorches) {
                this.setTorchCount(stack, maxTorches);
                invStack.func_190918_g(maxTorches - current);
            } else {
                this.setTorchCount(stack, current + invStack.func_190916_E());
                invStack.func_190920_e(0);
            }
            if (invStack.func_190916_E() > 0) continue;
            PlayerHelper.removeItem((EntityPlayer)player, (ItemStack)invStack);
        }
    }

    public int absorbTorchesFromEntityItem(ItemStack bandolier, ItemStack blockStack) {
        int bandolierCount = this.getTorchCount(bandolier);
        int maxTorches = this.getMaxTorchCount(bandolier);
        int blockCount = blockStack.func_190916_E();
        if (bandolierCount + blockCount > maxTorches) {
            this.setTorchCount(bandolier, maxTorches);
            return maxTorches - bandolierCount;
        }
        this.setTorchCount(bandolier, bandolierCount + blockCount);
        return blockCount;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.field_70170_p.field_72995_K && playerIn.func_70093_af()) {
            boolean mode = !this.isAutoFillOn(stack);
            this.setAutoFill(stack, mode);
            String translationKey = "item.torchbandolier.torch_bandolier.autoFill." + (mode ? "on" : "off");
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(translationKey, new Object[0]), true);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getTorchCount(stack) <= 0 && !player.field_71075_bZ.field_75098_d) {
            return EnumActionResult.PASS;
        }
        Block block = this.getBlockPlaced(stack);
        ItemStack fakeBlockStack = new ItemStack(block);
        EnumActionResult result = ItemHelper.useItemAsPlayer((ItemStack)fakeBlockStack, (EntityPlayer)player, (World)worldIn, (BlockPos)pos, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ);
        if (result == EnumActionResult.SUCCESS && !player.field_71075_bZ.field_75098_d) {
            this.setTorchCount(stack, this.getTorchCount(stack) - 1);
        }
        return result;
    }

    public ActionResult<ItemStack> onItemLeftClickSL(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_70093_af() && this.getTorchCount(stack) > 0) {
            Block block = this.getBlockPlaced(stack);
            ItemStack toDrop = new ItemStack(block);
            toDrop.func_190920_e(Math.min(this.getTorchCount(stack), toDrop.func_77976_d()));
            this.setTorchCount(stack, this.getTorchCount(stack) - toDrop.func_190916_E());
            Vec3d vec = player.func_70040_Z().func_186678_a(2.0);
            EntityItem entity = new EntityItem(world, player.field_70165_t + vec.field_72450_a, player.field_70163_u + 1.0 + vec.field_72448_b, player.field_70161_v + vec.field_72449_c, toDrop);
            vec = vec.func_186678_a(-0.125);
            entity.field_70159_w = vec.field_72450_a;
            entity.field_70181_x = vec.field_72448_b;
            entity.field_70179_y = vec.field_72449_c;
            EntityHelper.safeSpawn((Entity)entity);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this);
        ItemStack full = new ItemStack((Item)this);
        this.setTorchCount(full, this.getMaxTorchCount(full));
        items.add((Object)empty);
        items.add((Object)full);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean autoFill = this.isAutoFillOn(stack);
        int torches = this.getTorchCount(stack);
        int maxTorches = this.getMaxTorchCount(stack);
        tooltip.add(TorchBandolier.i18n.subText((IForgeRegistryEntry)this, "count", new Object[]{torches, maxTorches}));
        tooltip.add(TorchBandolier.i18n.subText((IForgeRegistryEntry)this, "autoFill." + (autoFill ? "on" : "off"), new Object[0]));
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int max = this.getMaxTorchCount(stack);
        if (max <= 0) {
            return 1.0;
        }
        return 1.0 - (double)this.getTorchCount(stack) / (double)max;
    }

    public Block getBlockPlaced(ItemStack stack) {
        return Blocks.field_150478_aa;
    }

    public int getTorchCount(ItemStack stack) {
        return stack.func_190925_c(NBT_ROOT).func_74762_e(NBT_COUNT);
    }

    public void setTorchCount(ItemStack stack, int value) {
        stack.func_190925_c(NBT_ROOT).func_74768_a(NBT_COUNT, value);
    }

    public int getMaxTorchCount(ItemStack stack) {
        return 1024;
    }

    public boolean isAutoFillOn(ItemStack stack) {
        return stack.func_190925_c(NBT_ROOT).func_74767_n(NBT_AUTO_FILL);
    }

    public void setAutoFill(ItemStack stack, boolean value) {
        stack.func_190925_c(NBT_ROOT).func_74757_a(NBT_AUTO_FILL, value);
    }
}

