/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.gui;

import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class DebugRenderOverlay
extends Gui {
    private List<String> debugText = this.getDebugText();
    private int ticksPassed = 0;

    protected DebugRenderOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    public abstract List<String> getDebugText();

    public abstract float getTextScale();

    @Nonnegative
    public int getUpdateFrequency() {
        return 10;
    }

    @Nonnegative
    public int getSplitWidth() {
        return 100;
    }

    public abstract boolean isHidden();

    protected void drawLine(FontRenderer font, String line, int x, int y, int color) {
        String[] array = line.split("=");
        if (array.length == 2) {
            font.func_175063_a(array[0].trim(), (float)x, (float)y, color);
            font.func_175063_a(array[1].trim(), (float)(x + this.getSplitWidth()), (float)y, color);
        } else {
            font.func_175063_a(line, (float)x, (float)y, color);
        }
    }

    @SubscribeEvent
    public void renderTick(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isHidden() || this.debugText.isEmpty() || mc.func_147113_T() || mc.field_71474_y.field_74330_P || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        float scale = this.getTextScale();
        if (scale <= 0.0f) {
            return;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int x = 3;
        int y = 3;
        for (String line : this.debugText) {
            this.drawLine(font, line, x, y, 0xFFFFFF);
            y += 10;
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this.getUpdateFrequency() == 0 || ++this.ticksPassed % this.getUpdateFrequency() == 0) {
            this.debugText = this.getDebugText();
        }
    }
}

