/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.silentchaos512.lib.collection.IMatchList;

public abstract class AbstractMatchList<T>
implements IMatchList<T> {
    private boolean whitelist;
    private List<String> list = new ArrayList<String>();
    private final boolean allowUserToChangeType;
    private final String[] defaultValues;
    private final boolean defaultIsWhitelist;
    private static final String NAME_LIST_SUFFIX = " List";
    private static final String NAME_WHITELIST_SUFFIX = " IsWhitelist";
    private static final String COMMENT_WHITELIST = "If true, the list is a whitelist. Otherwise it is a blacklist.";

    AbstractMatchList(boolean whitelist, boolean allowUserToChangeType, String ... defaultValues) {
        this.whitelist = this.defaultIsWhitelist = whitelist;
        this.allowUserToChangeType = allowUserToChangeType;
        this.defaultValues = defaultValues;
    }

    @Override
    public boolean matches(T t) {
        return this.contains(t) == this.isWhitelist();
    }

    protected abstract boolean contains(T var1);

    protected boolean containsKey(String key) {
        return this.list.stream().anyMatch(entry -> entry.equalsIgnoreCase(key));
    }

    @Override
    public void loadConfig(Configuration config, String name, String category, String comment) {
        this.list.clear();
        Collections.addAll(this.list, config.getStringList(name + NAME_LIST_SUFFIX, category, this.defaultValues, comment));
        if (this.allowUserToChangeType) {
            this.whitelist = config.getBoolean(name + NAME_WHITELIST_SUFFIX, category, this.defaultIsWhitelist, COMMENT_WHITELIST);
        }
    }

    protected boolean isWhitelist() {
        return this.whitelist;
    }

    List<String> getList() {
        return this.list;
    }
}

