/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;

public class StackList
extends ArrayList<ItemStack> {
    private StackList() {
    }

    public static StackList of(ItemStack ... stacks) {
        StackList newList = new StackList();
        Collections.addAll(newList, stacks);
        return newList;
    }

    public ItemStack firstOfType(Class<?> itemClass) {
        return this.firstMatch(this.itemClassMatcher(itemClass));
    }

    public ItemStack firstMatch(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).findFirst().orElse(ItemStack.field_190927_a);
    }

    public ItemStack uniqueOfType(Class<?> itemClass) {
        return this.uniqueMatch(this.itemClassMatcher(itemClass));
    }

    public ItemStack uniqueMatch(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.size() == 1 ? (ItemStack)list.get(0) : ItemStack.field_190927_a));
    }

    public Collection<ItemStack> allOfType(Class<?> itemClass) {
        return this.allMatches(this.itemClassMatcher(itemClass));
    }

    public Collection<ItemStack> allMatches(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).collect(Collectors.toList());
    }

    public int countOfType(Class<?> itemClass) {
        return this.countOfMatches(this.itemClassMatcher(itemClass));
    }

    public int countOfMatches(Predicate<ItemStack> predicate) {
        return (int)this.stream().filter(predicate).count();
    }

    private Predicate<ItemStack> itemClassMatcher(Class<?> itemClass) {
        return stack -> itemClass.isInstance(stack.func_77973_b());
    }

    @Override
    public boolean add(ItemStack itemStack) {
        return !itemStack.func_190926_b() && super.add(itemStack);
    }

    @Override
    public boolean addAll(Collection<? extends ItemStack> c) {
        boolean added = false;
        for (ItemStack itemStack : c) {
            if (itemStack.func_190926_b()) continue;
            added |= super.add(itemStack);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends ItemStack> c) {
        boolean added = false;
        for (ItemStack itemStack : c) {
            if (itemStack.func_190926_b()) continue;
            super.add(index, itemStack);
            added = true;
        }
        return added;
    }

    @Override
    public void add(int index, ItemStack element) {
        if (!element.func_190926_b()) {
            super.add(index, element);
        }
    }
}

