/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.config;

import com.google.common.primitives.UnsignedInts;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.lib.registry.IPhasedInitializer;
import net.silentchaos512.lib.registry.SRegistry;

public abstract class ConfigBase
implements IPhasedInitializer {
    public static final String SEP = ".";
    public static final String CAT_MAIN = "main";
    protected Configuration config;
    protected final String modId;

    public ConfigBase(String modId) {
        this.modId = modId;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public abstract void load();

    public int loadInt(String key, String category, int defaultValue, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment);
        return prop.getInt(defaultValue);
    }

    public int loadInt(String key, String category, int defaultValue, int min, int max, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment + " [range: " + min + " ~ " + max + ", default: " + defaultValue + "]");
        prop.setMinValue(min);
        prop.setMaxValue(max);
        int val = prop.getInt(defaultValue);
        return val < min ? min : (val > max ? max : val);
    }

    public double loadDouble(String key, String category, double defaultValue, String comment) {
        Property prop = this.config.get(category, key, Double.toString(defaultValue));
        prop.setComment(comment);
        double val = 0.0;
        try {
            val = Double.parseDouble(prop.getString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public double loadDouble(String key, String category, double defaultValue, double min, double max, String comment) {
        Property prop = this.config.get(category, key, Double.toString(defaultValue));
        prop.setComment(comment + " [range: " + min + " ~ " + max + ", default: " + defaultValue + "]");
        prop.setMinValue(min);
        prop.setMaxValue(max);
        double val = 0.0;
        try {
            val = Double.parseDouble(prop.getString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val < min ? min : (val > max ? max : val);
    }

    public float loadFloat(String key, String category, float defaultValue, String comment) {
        return (float)this.loadDouble(key, category, defaultValue, comment);
    }

    public float loadFloat(String key, String category, float defaultValue, float min, float max, String comment) {
        return (float)this.loadDouble(key, category, defaultValue, min, max, comment);
    }

    public boolean loadBoolean(String key, String category, boolean defaultValue, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment);
        return prop.getBoolean();
    }

    public int loadColorCode(String key, String category, int defaultValue, boolean includeAlpha, String comment) throws NumberFormatException {
        String str = this.config.getString(key, category, String.format(includeAlpha ? "%08x" : "%06x", defaultValue), comment);
        int result = UnsignedInts.parseUnsignedInt((String)str, (int)16);
        if (includeAlpha && (result & 0xFF000000) == 0) {
            result |= 0xFF000000;
        }
        return result;
    }

    public <T extends Enum<T>> T loadEnum(String key, String category, Class<T> enumClass, T defaultValue, String comment) {
        return this.loadEnum(key, category, enumClass, defaultValue, comment, true);
    }

    public <T extends Enum<T>> T loadEnum(String key, String category, Class<T> enumClass, T defaultValue, String comment, boolean appendValidValuesToComment) {
        Object[] validValues = new String[((Enum[])enumClass.getEnumConstants()).length];
        for (Enum t : (Enum[])enumClass.getEnumConstants()) {
            validValues[t.ordinal()] = t.name();
        }
        if (appendValidValuesToComment) {
            comment = comment + "\nValid values: " + Arrays.toString(validValues);
        }
        String value = this.config.getString(key, category, defaultValue.name(), comment, (String[])validValues);
        for (Enum t : (Enum[])enumClass.getEnumConstants()) {
            if (!t.name().equalsIgnoreCase(value)) continue;
            return (T)t;
        }
        return defaultValue;
    }

    public void init(File file) {
        this.config = new Configuration(file);
        this.load();
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase(this.modId)) {
            this.load();
            this.save();
        }
    }

    public ConfigCategory getCategory(String category) {
        return this.config.getCategory(category);
    }

    @Deprecated
    public List<IConfigElement> getConfigElements() {
        return new ConfigElement(this.getCategory(CAT_MAIN)).getChildElements();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void preInit(SRegistry registry, FMLPreInitializationEvent event) {
        this.init(event.getSuggestedConfigurationFile());
    }

    @Override
    public void init(SRegistry registry, FMLInitializationEvent event) {
        this.save();
    }

    @Override
    public void postInit(SRegistry registry, FMLPostInitializationEvent event) {
    }
}

