/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.debug;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.SilentLib;

public class DataDump {
    static final String SEPARATOR = "--------------------------------------------------------------------------------";

    public static void dumpEnchantments() {
        SilentLib.logHelper.info((Object)SEPARATOR);
        SilentLib.logHelper.info((Object)"The following is a list of all enchantments registered as of Silent Lib's post-init:");
        for (Enchantment ench : Enchantment.field_185264_b) {
            try {
                String str = "  %-30s %-40s type=%-10s";
                str = String.format(str, ench.func_77316_c(1).replaceFirst(" I$", ""), ench.getRegistryName(), ench.field_77351_y == null ? "null" : ench.field_77351_y.name());
                SilentLib.logHelper.info((Object)str);
            }
            catch (Exception ex) {
                SilentLib.logHelper.info((Object)("Errored on enchantment: " + ench));
            }
        }
        SilentLib.logHelper.info((Object)SEPARATOR);
    }

    public static void dumpEntityList() {
        SilentLib.logHelper.info((Object)SEPARATOR);
        SilentLib.logHelper.info((Object)"The following is a list of all entities registered as of Silent Lib's post-init:");
        ArrayList list = Lists.newArrayList();
        for (ResourceLocation res : EntityList.func_180124_b()) {
            try {
                Class clazz = EntityList.getClass((ResourceLocation)res);
                String name = EntityList.func_191302_a((ResourceLocation)res);
                int id = EntityList.getID((Class)clazz);
                String str2 = "  %-30s %4d   %-40s %-40s";
                str2 = String.format(str2, name, id, res, clazz);
                list.add(str2);
            }
            catch (Exception ex) {
                list.add("***Errored on entity: " + res);
            }
        }
        list.sort((s1, s2) -> s1.compareToIgnoreCase((String)s2));
        list.forEach(str -> SilentLib.logHelper.info(str));
        SilentLib.logHelper.info((Object)SEPARATOR);
    }

    public static void dumpPotionEffects() {
        SilentLib.logHelper.info((Object)SEPARATOR);
        SilentLib.logHelper.info((Object)"The following is a list of all potion effects registered as of Silent Lib's post-init:");
        for (Potion pot : Potion.field_188414_b) {
            try {
                String str = "%-30s %-40s";
                str = String.format(str, pot.func_76393_a(), pot.getRegistryName().toString());
                SilentLib.logHelper.info((Object)str);
            }
            catch (Exception ex) {
                SilentLib.logHelper.info((Object)("Errored on potion: " + pot));
            }
        }
        SilentLib.logHelper.info((Object)SEPARATOR);
    }

    public static void dumpRecipes() {
        SilentLib.logHelper.info((Object)SEPARATOR);
        SilentLib.logHelper.info((Object)"The following is a list of all recipes registered as of Silent Lib's post-init:");
        for (IRecipe rec : CraftingManager.field_193380_a) {
            try {
                int id = CraftingManager.field_193380_a.func_148757_b((Object)rec);
                if (id < 0) {
                    throw new IndexOutOfBoundsException("id < 0");
                }
                String str = "%-6d %-40s";
                str = String.format(str, id, rec.getRegistryName().toString());
                SilentLib.logHelper.info((Object)str);
            }
            catch (Exception ex) {
                SilentLib.logHelper.info((Object)("Errored on recipe: " + rec));
                throw ex;
            }
        }
        SilentLib.logHelper.info((Object)SEPARATOR);
    }
}

