/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.draft;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.silentchaos512.lib.tile.SyncVariable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class PlayerDataHandler {
    protected final String nbtRootKey;
    protected final Map<Integer, PlayerData> playerData = new HashMap<Integer, PlayerData>();

    protected PlayerDataHandler(String nbtRootKey) {
        this.nbtRootKey = nbtRootKey;
    }

    public abstract <T extends PlayerDataHandler> T instance();

    public NBTTagCompound getDataCompoundForPlayer(EntityPlayer player) {
        throw new NotImplementedException();
    }

    public abstract class PlayerData {
        public WeakReference<EntityPlayer> playerWR;
        protected final boolean client;

        public PlayerData(EntityPlayer player) {
            this.playerWR = new WeakReference<EntityPlayer>(player);
            this.client = player.field_70170_p.field_72995_K;
            this.load();
        }

        public abstract void tick();

        protected void sendUpdateMessage() {
            if (!this.client) {
                EntityPlayer entityPlayer = (EntityPlayer)this.playerWR.get();
            }
        }

        public final void save() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = PlayerDataHandler.this.getDataCompoundForPlayer(player);
                this.writeToNBT(tags);
                SyncVariable.Helper.writeSyncVars(this, tags, SyncVariable.Type.WRITE);
            }
        }

        public abstract void writeToNBT(NBTTagCompound var1);

        public final void load() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = PlayerDataHandler.this.getDataCompoundForPlayer(player);
                this.readFromNBT(tags);
                SyncVariable.Helper.readSyncVars(this, tags);
            }
        }

        public abstract void readFromNBT(NBTTagCompound var1);
    }
}

