/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientTicks {
    public static final ClientTicks INSTANCE = new ClientTicks();
    private static volatile Queue<Runnable> scheduledActions = new ArrayDeque<Runnable>();
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;
    public static float deltaTicks = 0.0f;
    public static float totalTicks = 0.0f;

    private ClientTicks() {
    }

    public void scheduleAction(Runnable action) {
        scheduledActions.add(action);
    }

    @SubscribeEvent
    public void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.runScheduledActions();
        this.updateTickCounters();
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
        }
    }

    private void runScheduledActions() {
        Runnable action = scheduledActions.poll();
        while (action != null) {
            action.run();
            action = scheduledActions.poll();
        }
    }

    private void updateTickCounters() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null || !gui.func_73868_f()) {
            ++ticksInGame;
            partialTicks = 0.0f;
        }
        float oldTotal = totalTicks;
        totalTicks = (float)ticksInGame + partialTicks;
        deltaTicks = totalTicks - oldTotal;
    }
}

