/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerTicks {
    public static final ServerTicks INSTANCE = new ServerTicks();
    private static volatile Queue<Runnable> scheduledActions = new ArrayDeque<Runnable>();

    private ServerTicks() {
    }

    public static void scheduleAction(Runnable action) {
        scheduledActions.add(action);
    }

    @SubscribeEvent
    public void serverTicks(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.runScheduledActions();
    }

    private void runScheduledActions() {
        Runnable action = scheduledActions.poll();
        while (action != null) {
            action.run();
            action = scheduledActions.poll();
        }
    }
}

