/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.guidebook.IGuideChapter;
import net.silentchaos512.lib.guidebook.IGuideEntry;
import net.silentchaos512.lib.guidebook.IGuidePage;
import net.silentchaos512.lib.guidebook.entry.GuideEntry;
import net.silentchaos512.lib.guidebook.entry.GuideEntryAllItems;
import net.silentchaos512.lib.guidebook.gui.GuiGuide;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.LogHelper;

public abstract class GuideBook {
    protected final String modId;
    protected final List<IGuideEntry> entries = Lists.newArrayList();
    protected final List<IGuideChapter> chapters = Lists.newArrayList();
    protected final List<IGuidePage> pagesWithItemOrFluidData = Lists.newArrayList();
    protected ResourceLocation resourceGui;
    protected ResourceLocation resourceGadgets;
    public GuideEntry entryAllAndSearch = new GuideEntryAllItems(this, "allAndSearch").setImportant();
    public final LocalizationHelper loc;
    public int edition = -1;
    public boolean showPatreonButton = false;
    @SideOnly(value=Side.CLIENT)
    public GuiGuide lastViewedPage;

    public GuideBook(String modId) {
        this.modId = modId;
        this.showPatreonButton = modId.equals("silentgems");
        this.resourceGui = new ResourceLocation("silentlib", "textures/gui/gui_guide.png");
        this.resourceGadgets = new ResourceLocation("silentlib", "textures/gui/gui_guide_gadgets.png");
        LocalizationHelper locForMod = SilentLib.instance.getLocalizationHelperForMod(modId);
        if (locForMod == null) {
            SilentLib.logHelper.warning((Object)String.format("<Guide Book> Mod \"%s\" has no localization helper! A new one will be created, but not registered for use with blocks/items.", modId));
            this.loc = new LocalizationHelper(modId).setReplaceAmpersand(true);
        } else {
            this.loc = locForMod;
        }
    }

    public final void preInit() {
        this.initEntries();
    }

    public final void postInit() {
        this.initChapters();
        int countChapter = 0;
        int countPage = 0;
        int countInfo = 0;
        for (IGuideEntry entry : this.entries) {
            for (IGuideChapter chapter : entry.getAllChapters()) {
                if (this.chapters.contains(chapter)) continue;
                this.chapters.add(chapter);
                ++countChapter;
                for (IGuidePage page : chapter.getAllPages()) {
                    ++countPage;
                    ArrayList items = Lists.newArrayList();
                    page.getItemStacksForPage(items);
                    ArrayList fluids = Lists.newArrayList();
                    page.getFluidStacksForPage(fluids);
                    if ((items == null || items.isEmpty()) && (fluids == null || fluids.isEmpty()) || this.pagesWithItemOrFluidData.contains(page)) continue;
                    this.pagesWithItemOrFluidData.add(page);
                    ++countInfo;
                }
            }
        }
        this.entries.sort(Comparator.comparing(IGuideEntry::getSortingPriority, (a, b) -> b.compareTo((Integer)a)));
        this.chapters.sort(Comparator.comparing(IGuideChapter::getSortingPriority, (a, b) -> b.compareTo((Integer)a)));
        this.pagesWithItemOrFluidData.sort(Comparator.comparing(IGuidePage::getSortingPriority, (a, b) -> b.compareTo((Integer)a)));
        LogHelper log = SilentLib.logHelper;
        log.info((Object)String.format("Guide book for mod \"%s\" initialized!", this.modId));
        log.info((Object)("    Entries:  " + this.entries.size()));
        log.info((Object)("    Chapters: " + countChapter));
        log.info((Object)("    Pages:    " + countPage));
        log.info((Object)("    Info:     " + countInfo));
    }

    public abstract void initEntries();

    public abstract void initChapters();

    public abstract String[] getQuotes();

    @Nonnull
    public String selectQuote(Random rand) {
        String[] quotes = this.getQuotes();
        if (quotes.length > 0) {
            return quotes[rand.nextInt(quotes.length)];
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public abstract GuiScreen getConfigScreen(GuiScreen var1);

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public abstract GuiScreen getAchievementScreen(GuiScreen var1);

    public ResourceLocation getResourceGui() {
        return this.resourceGui;
    }

    public ResourceLocation getResourceGadgets() {
        return this.resourceGadgets;
    }

    public String getEditionString(EntityPlayer player) {
        String str = this.getEditionNumberString();
        return this.loc.getLocalizedString("guide.silentlib:edition", str);
    }

    protected String getEditionNumberString() {
        if (this.edition >= 11 && this.edition <= 13) {
            return this.edition + "th";
        }
        int mod10 = this.edition % 10;
        String str = this.edition + (mod10 == 1 ? "st" : (mod10 == 2 ? "nd" : (mod10 == 3 ? "rd" : "th")));
        return str;
    }

    public String getModId() {
        return this.modId;
    }

    public List<IGuideChapter> getChapters() {
        return this.chapters;
    }

    public List<IGuideEntry> getEntries() {
        return this.entries;
    }

    public List<IGuidePage> getPagesWithItemOrFluidData() {
        return this.pagesWithItemOrFluidData;
    }

    public void addEntry(IGuideEntry entry) {
        this.entries.add(entry);
    }
}

