/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.entry;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.IGuideChapter;
import net.silentchaos512.lib.guidebook.IGuideEntry;
import net.silentchaos512.lib.guidebook.IGuidePage;
import net.silentchaos512.lib.util.StackHelper;

public class GuideEntry
implements IGuideEntry {
    private final String identifier;
    private final int priority;
    private final List<IGuideChapter> chapters = new ArrayList<IGuideChapter>();
    private TextFormatting color;
    protected final GuideBook book;

    public GuideEntry(GuideBook book, String key) {
        this(book, key, 0);
    }

    public GuideEntry(GuideBook book, String key, int priority) {
        this.identifier = key;
        this.priority = priority;
        this.book = book;
        book.addEntry(this);
        this.color = TextFormatting.RESET;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean fitsFilter(IGuidePage page, String searchBarText) {
        Minecraft mc = Minecraft.func_71410_x();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        page.getItemStacksForPage(items);
        if (!items.isEmpty()) {
            for (ItemStack stack : items) {
                if (!StackHelper.isValid(stack)) continue;
                ITooltipFlag.TooltipFlags tooltipFlag = mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
                List tooltip = stack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)tooltipFlag);
                for (String strg : tooltip) {
                    if (strg == null || !strg.toLowerCase(Locale.ROOT).contains(searchBarText)) continue;
                    return true;
                }
            }
        }
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        page.getFluidStacksForPage(fluids);
        if (!fluids.isEmpty()) {
            for (FluidStack stack : fluids) {
                String strg;
                if (stack == null || (strg = stack.getLocalizedName()) == null || !strg.toLowerCase(Locale.ROOT).contains(searchBarText)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IGuideChapter> getAllChapters() {
        return this.chapters;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return this.book.loc.getLocalizedString("guide", "indexEntry." + this.getIdentifier() + ".name", new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedNameWithFormatting() {
        return this.color + this.getLocalizedName();
    }

    @Override
    public void addChapter(IGuideChapter chapter) {
        this.chapters.add(chapter);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IGuideChapter> getChaptersForDisplay(String searchBarText) {
        if (searchBarText != null && !searchBarText.isEmpty()) {
            String search = searchBarText.toLowerCase(Locale.ROOT);
            ArrayList<IGuideChapter> fittingChapters = new ArrayList<IGuideChapter>();
            block0: for (IGuideChapter chapter : this.getAllChapters()) {
                if (chapter.getLocalizedName().toLowerCase(Locale.ROOT).contains(search)) {
                    fittingChapters.add(chapter);
                    continue;
                }
                for (IGuidePage page : chapter.getAllPages()) {
                    if (!GuideEntry.fitsFilter(page, search)) continue;
                    fittingChapters.add(chapter);
                    continue block0;
                }
            }
            return fittingChapters;
        }
        return this.getAllChapters();
    }

    @Override
    public int getSortingPriority() {
        return this.priority;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean visibleOnFrontPage() {
        return true;
    }

    public GuideEntry setImportant() {
        this.color = TextFormatting.DARK_GREEN;
        return this;
    }

    public GuideEntry setSpecial() {
        this.color = TextFormatting.DARK_PURPLE;
        return this;
    }
}

