/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public final class RecipeJsonHell {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private RecipeJsonHell() {
        throw new IllegalAccessError("Utility class");
    }

    public static void createShapedRecipe(String name, ItemStack result, Object ... components) {
        int i;
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        HashMap<String, Map<String, Object>> inputMap = new HashMap<String, Map<String, Object>>();
        boolean isOreDict = false;
        Character curKey = null;
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        while (i < components.length) {
            Object component = components[i];
            if (component instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)component;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (component instanceof String) {
                    isOreDict = true;
                }
                inputMap.put(Character.toString(curKey.charValue()), RecipeJsonHell.serializeComponent(component));
                curKey = null;
            }
            ++i;
        }
        json.put("pattern", pattern);
        json.put("key", inputMap);
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("result", RecipeJsonHell.serializeComponent(result));
        RecipeJsonHell.createRecipeFile(json, name);
    }

    public static void createShapelessRecipe(String name, ItemStack result, Object ... components) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        boolean isOreDict = false;
        for (Object component : components) {
            if (component instanceof String) {
                isOreDict = true;
            }
            ingredients.add(RecipeJsonHell.serializeComponent(component));
        }
        json.put("ingredients", ingredients);
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("result", RecipeJsonHell.serializeComponent(result));
        RecipeJsonHell.createRecipeFile(json, name);
    }

    private static Map<String, Object> serializeComponent(Object component) {
        if (component instanceof Item) {
            return RecipeJsonHell.serializeComponent(new ItemStack((Item)component));
        }
        if (component instanceof Block) {
            return RecipeJsonHell.serializeComponent(new ItemStack((Block)component));
        }
        if (component instanceof ItemStack) {
            ItemStack stack = (ItemStack)component;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                throw new IllegalArgumentException("Too lazy to implement nbt support rn");
            }
            return ret;
        }
        if (component instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("type", "forge:ore_dict");
            ret.put("ore", component);
            return ret;
        }
        throw new IllegalArgumentException("Could not serialize the unsupported type " + component.getClass().getName());
    }

    private static void createRecipeFile(Map<String, Object> json, String fileName) {
        fileName = fileName.replaceAll(":", "_");
        File directory = new File("recipes/" + Loader.instance().activeModContainer().getModId());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File output = new File(directory, fileName + ".json");
        try (FileWriter writer = new FileWriter(output);){
            GSON.toJson(json, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

