/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.registry;

import com.google.common.collect.MapMaker;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.block.IColoredBlock;
import net.silentchaos512.lib.block.ITileEntityBlock;
import net.silentchaos512.lib.item.IColoredItem;
import net.silentchaos512.lib.item.ItemBlockSL;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomMesh;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.registry.IPhasedInitializer;
import net.silentchaos512.lib.registry.IRegistrationHandler;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.LogHelper;

public class SRegistry {
    private final Set<IRegistryObject> registryObjects = new HashSet<IRegistryObject>();
    private final List<Block> blocks = NonNullList.func_191196_a();
    private final List<Item> items = NonNullList.func_191196_a();
    private final List<IAddRecipes> recipeAdders = NonNullList.func_191196_a();
    private final List<Block> coloredBlocks = NonNullList.func_191196_a();
    private final List<Item> coloredItems = NonNullList.func_191196_a();
    private List<IPhasedInitializer> phasedInitializers = new ArrayList<IPhasedInitializer>();
    private Map<Class, IRegistrationHandler> registrationHandlers = new THashMap();
    protected Object mod;
    @Nullable
    protected LogHelper logHelper;
    public final String modId;
    private final String resourcePrefix;
    @Nonnull
    public RecipeMaker recipes;
    @Nullable
    private CreativeTabs defaultCreativeTab = null;
    protected int lastEntityId = -1;

    public SRegistry(String modId) {
        this.modId = modId;
        this.resourcePrefix = modId.toLowerCase(Locale.ROOT) + ":";
        this.recipes = new RecipeMaker(modId);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler(this));
    }

    public SRegistry(String modId, LogHelper logHelper) {
        this(modId);
        this.logHelper = logHelper;
    }

    public void setMod(Object mod) {
        this.mod = mod;
    }

    public IPhasedInitializer addPhasedInitializer(IPhasedInitializer instance) {
        this.phasedInitializers.add(instance);
        return instance;
    }

    public <T> IRegistrationHandler<T> addRegistrationHandler(IRegistrationHandler<T> handler, Class<T> clazz) {
        this.registrationHandlers.put(clazz, handler);
        return handler;
    }

    public CreativeTabs makeCreativeTab(String label, final Supplier<ItemStack> icon) {
        CreativeTabs tab = new CreativeTabs(label){

            public ItemStack func_78016_d() {
                return (ItemStack)icon.get();
            }
        };
        if (this.defaultCreativeTab == null) {
            this.defaultCreativeTab = tab;
        }
        return tab;
    }

    public <T extends Block> T registerBlock(T block) {
        return this.registerBlock(block, ((IRegistryObject)block).getName());
    }

    public <T extends Block> T registerBlock(T block, String key) {
        return this.registerBlock(block, key, block instanceof IRegistryObject ? new ItemBlockSL(block) : new ItemBlock(block));
    }

    public <T extends Block> T registerBlock(T block, ItemBlock itemBlock) {
        return this.registerBlock(block, ((IRegistryObject)block).getName(), itemBlock);
    }

    public <T extends Block> T registerBlock(T block, String key, ItemBlock itemBlock) {
        if (block instanceof IRegistryObject) {
            this.registryObjects.add((IRegistryObject)block);
        } else {
            block.func_149663_c(this.modId + "." + key);
        }
        this.blocks.add(block);
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry)block, name);
        ForgeRegistries.BLOCKS.register(block);
        this.safeSetRegistryName((IForgeRegistryEntry)itemBlock, name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        if (block instanceof ITileEntityBlock) {
            Class<? extends TileEntity> clazz = ((ITileEntityBlock)block).getTileEntityClass();
            this.registerTileEntity(clazz, key);
        }
        if (block instanceof IAddRecipes) {
            this.recipeAdders.add((IAddRecipes)block);
        }
        if (block instanceof IColoredBlock) {
            this.coloredBlocks.add(block);
        }
        if (this.defaultCreativeTab != null) {
            block.func_149647_a(this.defaultCreativeTab);
        }
        return block;
    }

    public <T extends Item> T registerItem(T item) {
        return this.registerItem(item, ((IRegistryObject)item).getName());
    }

    public <T extends Item> T registerItem(T item, String key) {
        if (item instanceof IRegistryObject) {
            this.registryObjects.add((IRegistryObject)item);
        } else {
            item.func_77655_b(this.modId + "." + key);
        }
        this.items.add(item);
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry)item, name);
        ForgeRegistries.ITEMS.register(item);
        if (item instanceof IAddRecipes) {
            this.recipeAdders.add((IAddRecipes)item);
        }
        if (item instanceof IColoredItem) {
            this.coloredItems.add(item);
        }
        if (this.defaultCreativeTab != null) {
            item.func_77637_a(this.defaultCreativeTab);
        }
        return item;
    }

    public void registerEnchantment(Enchantment enchantment, String key) {
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry)enchantment, name);
        ForgeRegistries.ENCHANTMENTS.register((IForgeRegistryEntry)enchantment);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key) {
        this.registerEntity(entityClass, key, ++this.lastEntityId, this.mod, 64, 20, true);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        this.registerEntity(entityClass, key, ++this.lastEntityId, this.mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ResourceLocation resource = new ResourceLocation(this.modId, key);
        EntityRegistry.registerModEntity((ResourceLocation)resource, entityClass, (String)key, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        this.registerEntity(entityClass, key, ++this.lastEntityId, this.mod, trackingRange, updateFrequency, sendsVelocityUpdates, eggPrimary, eggSecondary);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        ResourceLocation resource = new ResourceLocation(this.modId, key);
        EntityRegistry.registerModEntity((ResourceLocation)resource, entityClass, (String)key, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimary, (int)eggSecondary);
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends Entity> void registerEntityRenderer(Class<T> entityClass, IRenderFactory<T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory);
    }

    public void registerPotion(Potion potion) {
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)potion);
    }

    public void registerPotion(Potion potion, ResourceLocation name) {
        this.safeSetRegistryName((IForgeRegistryEntry)potion, name);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)potion);
    }

    public void registerSoundEvent(SoundEvent sound, String id) {
        this.registerSoundEvent(sound, new ResourceLocation(this.modId, id));
    }

    public void registerSoundEvent(SoundEvent sound, ResourceLocation name) {
        this.safeSetRegistryName((IForgeRegistryEntry)sound, name);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)sound);
    }

    public void safeSetRegistryName(IForgeRegistryEntry entry, ResourceLocation name) {
        if (entry.getRegistryName() == null) {
            entry.setRegistryName(name);
        }
    }

    public <T extends ICriterionInstance> ICriterionTrigger<T> registerAdvancementTrigger(ICriterionTrigger<T> trigger) {
        CriteriaTriggers.func_192118_a(trigger);
        return trigger;
    }

    public void registerTileEntity(Class<? extends TileEntity> tileClass, String key) {
        String fullKey = this.resourcePrefix + key;
        GameRegistry.registerTileEntity(tileClass, (String)fullKey);
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends TileEntity> void registerTileEntitySpecialRenderer(Class<T> tileClass, TileEntitySpecialRenderer<T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, renderer);
    }

    @Deprecated
    public void preInit() {
        if (this.mod == null) {
            SilentLib.logHelper.warn("Mod {} did not manually set its mod object! This is bad and may cause crashes.", this.modId);
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(this.modId);
            if (container != null) {
                this.mod = container.getMod();
                SilentLib.logHelper.warn("Automatically acquired mod object for {}", this.modId);
            } else if (this.logHelper != null) {
                SilentLib.logHelper.warn("Could not find mod object. The mod ID is likely incorrect.", new Object[0]);
            }
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.preInit();
        this.phasedInitializers.forEach(i -> i.preInit(this, event));
    }

    @Deprecated
    public void init() {
    }

    public void init(FMLInitializationEvent event) {
        this.init();
        this.phasedInitializers.forEach(i -> i.init(this, event));
    }

    @Deprecated
    public void postInit() {
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.postInit();
        this.phasedInitializers.forEach(i -> i.postInit(this, event));
    }

    @Deprecated
    public void clientPreInit() {
    }

    public void clientPreInit(FMLPreInitializationEvent event) {
        this.clientPreInit();
        for (IRegistryObject obj : this.registryObjects) {
            ITileEntityBlock tileBlock;
            TileEntitySpecialRenderer<?> tesr;
            if (!(obj instanceof ITileEntityBlock) || (tesr = (tileBlock = (ITileEntityBlock)((Object)obj)).getTileRenderer()) == null) continue;
            ClientRegistry.bindTileEntitySpecialRenderer(tileBlock.getTileEntityClass(), tesr);
        }
    }

    @Deprecated
    public void clientInit() {
    }

    public void clientInit(FMLInitializationEvent event) {
        this.clientInit();
    }

    @Deprecated
    public void clientPostInit() {
    }

    public void clientPostInit(FMLPostInitializationEvent event) {
        this.clientPostInit();
    }

    @Deprecated
    protected void addRecipes() {
        this.registryObjects.forEach(obj -> obj.addRecipes(this.recipes));
        this.recipeAdders.forEach(obj -> obj.addRecipes(this.recipes));
    }

    protected void addOreDictEntries() {
        this.registryObjects.forEach(obj -> obj.addOreDict());
        this.recipeAdders.forEach(obj -> obj.addOreDict());
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModels() {
        ModelResourceLocation model;
        ResourceLocation registryName;
        ConcurrentMap models = new MapMaker().initialCapacity(16).makeMap();
        for (IRegistryObject obj : this.registryObjects) {
            if (obj.registerModels()) continue;
            Item item = obj instanceof Block ? Item.func_150898_a((Block)((Block)obj)) : (Item)obj;
            models.clear();
            obj.getModels(models);
            models.forEach((key, value) -> ModelLoader.setCustomModelResourceLocation((Item)item, (int)key, (ModelResourceLocation)value));
        }
        for (Block block : this.blocks) {
            if (block instanceof IRegistryObject) continue;
            if (block instanceof ICustomModel) {
                ((ICustomModel)block).registerModels();
                continue;
            }
            registryName = Objects.requireNonNull(block.getRegistryName());
            model = new ModelResourceLocation(registryName, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)model);
        }
        for (Item item : this.items) {
            if (item instanceof IRegistryObject) continue;
            if (item instanceof ICustomMesh) {
                ICustomMesh customMesh = (ICustomMesh)item;
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])customMesh.getVariants());
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)customMesh.getCustomMesh());
                continue;
            }
            if (item instanceof ICustomModel) {
                ((ICustomModel)item).registerModels();
                continue;
            }
            registryName = Objects.requireNonNull(item.getRegistryName());
            model = new ModelResourceLocation(registryName, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)model);
        }
    }

    @Nullable
    public CreativeTabs getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    public void setDefaultCreativeTab(@Nullable CreativeTabs defaultCreativeTab) {
        this.defaultCreativeTab = defaultCreativeTab;
    }

    public static class EventHandler {
        protected SRegistry sregistry;

        public EventHandler(SRegistry sregistry) {
            this.sregistry = sregistry;
        }

        @SubscribeEvent
        public void registerBlocks(RegistryEvent.Register<Block> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(Block.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
        }

        @SubscribeEvent
        public void registerItems(RegistryEvent.Register<Item> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(Item.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
            this.sregistry.addOreDictEntries();
        }

        @SubscribeEvent
        public void registerPotions(RegistryEvent.Register<Potion> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(Potion.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
        }

        @SubscribeEvent
        public void registerBiomes(RegistryEvent.Register<Biome> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(Biome.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
        }

        @SubscribeEvent
        public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(SoundEvent.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
        }

        @SubscribeEvent
        public void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(PotionType.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
        }

        @SubscribeEvent
        public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(Enchantment.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
        }

        @SubscribeEvent
        public void registerVillagerProfessions(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(VillagerRegistry.VillagerProfession.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
        }

        @SubscribeEvent
        public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(EntityEntry.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
        }

        @SubscribeEvent
        public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            IRegistrationHandler handler = (IRegistrationHandler)this.sregistry.registrationHandlers.get(IRecipe.class);
            if (handler != null) {
                handler.registerAll(this.sregistry);
            }
            this.sregistry.addRecipes();
        }

        @SubscribeEvent
        public void registerModels(ModelRegistryEvent event) {
            this.sregistry.registerModels();
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void registerBlockColors(ColorHandlerEvent.Block event) {
            for (Block block : this.sregistry.coloredBlocks) {
                event.getBlockColors().func_186722_a(((IColoredBlock)block).getColorHandler(), new Block[]{block});
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void registerItemColors(ColorHandlerEvent.Item event) {
            for (Item item : this.sregistry.coloredItems) {
                event.getItemColors().func_186730_a(((IColoredItem)item).getColorHandler(), new Item[]{item});
            }
        }
    }
}

