/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import net.minecraft.util.math.MathHelper;

public class Color {
    public static final Color BLACK = new Color(0);
    public static final Color WHITE = new Color(0xFFFFFF);
    float red;
    float green;
    float blue;
    float alpha;

    public Color(int color) {
        this(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public Color(int red, int green, int blue) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
    }

    public Color(int red, int green, int blue, int alpha) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public Color blendWith(Color other) {
        return Color.blend(this, other);
    }

    public static Color blend(Color color1, Color color2) {
        return Color.blend(color1, color2, 0.5f);
    }

    public static Color blend(Color color1, Color color2, float ratio) {
        int i1 = color1.getColor();
        int i2 = color2.getColor();
        int color = Color.blend(i1, i2, ratio);
        return new Color(color);
    }

    public static int blend(int color1, int color2) {
        return Color.blend(color1, color2, 0.5f);
    }

    public static int blend(int color1, int color2, float ratio) {
        ratio = MathHelper.func_76131_a((float)ratio, (float)0.0f, (float)1.0f);
        float iRatio = 1.0f - ratio;
        int a1 = color1 >> 24 & 0xFF;
        int r1 = (color1 & 0xFF0000) >> 16;
        int g1 = (color1 & 0xFF00) >> 8;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = (color2 & 0xFF0000) >> 16;
        int g2 = (color2 & 0xFF00) >> 8;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        int color = a << 24 | r << 16 | g << 8 | b;
        return color;
    }

    public int getColor() {
        int r = (int)(this.red * 255.0f) << 16;
        int g = (int)(this.green * 255.0f) << 8;
        int b = (int)(this.blue * 255.0f);
        return r + g + b;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getRedInt() {
        return (int)(this.red * 255.0f);
    }

    public int getGreenInt() {
        return (int)(this.green * 255.0f);
    }

    public int getBlueInt() {
        return (int)(this.blue * 255.0f);
    }

    public int getAlphaInt() {
        return (int)(this.alpha * 255.0f);
    }
}

