/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.util.LogHelper;

@ParametersAreNonnullByDefault
public class I18nHelper {
    private final String modId;
    private final boolean clientSide;
    private final LogHelper log;
    private final boolean logServerTranslationAttempts;
    private final Set<String> triedToTranslateOnServer = new HashSet<String>();

    public I18nHelper(String modId, LogHelper log, boolean logServerTranslationAttempts) {
        this.modId = modId;
        this.log = log;
        this.logServerTranslationAttempts = logServerTranslationAttempts;
        this.clientSide = FMLCommonHandler.instance().getSide() == Side.CLIENT;
    }

    public boolean hasKey(String key) {
        return I18n.func_188566_a((String)key);
    }

    public String translate(String key, Object ... params) {
        if (!this.clientSide) {
            if (this.logServerTranslationAttempts && !this.triedToTranslateOnServer.contains(key)) {
                this.log.warn("Tried to translate text \"{}\" on server side", key);
                this.triedToTranslateOnServer.add(key);
            }
            return key;
        }
        return I18n.func_135052_a((String)key, (Object[])params);
    }

    public String translate(String prefix, String key, Object ... params) {
        return this.translate(prefix + "." + this.modId + "." + key, params);
    }

    public String subText(IForgeRegistryEntry<?> object, String key, Object ... params) {
        String prefix = this.getPrefixFor(object);
        ResourceLocation name = Objects.requireNonNull(object.getRegistryName());
        return this.translate(prefix + "." + name.func_110624_b() + "." + name.func_110623_a() + "." + key, params);
    }

    public String subText(String objName, String prefix, String key, Object ... params) {
        return this.translate(prefix, objName + "." + key, params);
    }

    public String blockSubText(String blockName, String key, Object ... params) {
        return this.subText(blockName, "tile", key, params);
    }

    public String itemSubText(String itemName, String key, Object ... params) {
        return this.subText(itemName, "item", key, params);
    }

    private String getPrefixFor(IForgeRegistryEntry<?> object) {
        if (object instanceof Item) {
            return "item";
        }
        if (object instanceof Block) {
            return "tile";
        }
        return object.getClass().getName().toLowerCase(Locale.ROOT);
    }
}

