/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogHelper {
    private Logger logger;
    private int buildNumber = 0;
    private String lastDebugOutput = "";

    @Deprecated
    public LogHelper(String modName) {
        this(modName, 0);
    }

    public LogHelper(String modName, int buildNumber) {
        this.logger = LogManager.getLogger((String)modName);
        this.buildNumber = buildNumber;
    }

    public void catching(Throwable t) {
        this.logger.catching(t);
    }

    public void debug(String msg, Object ... params) {
        this.logger.debug(msg, params);
    }

    public void error(String msg, Object ... params) {
        this.logger.error(msg, params);
    }

    public void fatal(String msg, Object ... params) {
        this.logger.fatal(msg, params);
    }

    public void info(String msg, Object ... params) {
        this.logger.info(msg, params);
    }

    public void log(Level level, String msg, Object ... params) {
        this.logger.log(level, msg, params);
    }

    public void trace(String msg, Object ... params) {
        this.logger.trace(msg, params);
    }

    public void warn(String msg, Object ... params) {
        this.logger.warn(msg, params);
    }

    public void warn(Throwable t, String msg, Object ... params) {
        this.logger.warn(msg, params);
        this.logger.catching(t);
    }

    public void noticableWarning(boolean trace, List<String> lines) {
        this.error("********************************************************************************", new Object[0]);
        for (String line : lines) {
            for (String subline : LogHelper.wrapString(line, 78, false, new ArrayList<String>())) {
                this.error("* " + subline, new Object[0]);
            }
        }
        if (trace) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 2; i < 8 && i < stackTrace.length; ++i) {
                this.warn("*  at {}{}", stackTrace[i].toString(), i == 7 ? "..." : "");
            }
        }
        this.error("********************************************************************************", new Object[0]);
    }

    public static List<String> wrapString(String string, int lnLength, boolean wrapLongWords, List<String> list) {
        String[] lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR);
        Collections.addAll(list, lines);
        return list;
    }

    @Deprecated
    public void debug(Object ... objects) {
        String line;
        if (this.buildNumber == 0 && !(line = this.lineFromList(objects)).equals(this.lastDebugOutput)) {
            this.logger.debug(line);
            System.out.println(line);
            this.lastDebugOutput = line;
        }
    }

    @Deprecated
    public void info(Object obj) {
        this.logger.info(obj);
    }

    @Deprecated
    public void info(Object ... objects) {
        this.logger.info(this.lineFromList(objects));
    }

    @Deprecated
    public void warning(Object obj) {
        this.logger.warn(obj);
    }

    @Deprecated
    public void warning(Object ... objects) {
        this.logger.warn(this.lineFromList(objects));
    }

    @Deprecated
    public void severe(Object obj) {
        this.logger.error(obj);
    }

    @Deprecated
    public void severe(Object ... objects) {
        this.logger.error(this.lineFromList(objects));
    }

    public void derp() {
        this.debug("Derp!", new Object[0]);
    }

    public String lineFromList(Object ... objects) {
        String str = "";
        for (int i = 0; i < objects.length; ++i) {
            if (i != 0) {
                str = str + ", ";
            }
            str = str + objects[i];
        }
        return str;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }
}

