/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.torchbandolier.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.silentchaos512.lib.item.ILeftClickItem;
import net.silentchaos512.lib.util.EntityHelper;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.torchbandolier.TorchBandolier;
import net.silentchaos512.torchbandolier.config.Config;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemTorchBandolier
extends Item
implements ILeftClickItem {
    private static final String NBT_ROOT = "TorchBandolier";
    private static final String NBT_AUTO_FILL = "AutoFill";
    private static final String NBT_COUNT = "Count";
    private static final int ABSORB_DELAY = 20;

    public ItemTorchBandolier() {
        super(new Item.Properties().func_200917_a(1).setNoRepair().func_200916_a(TorchBandolier.ITEM_GROUP));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 20L == 0L && entityIn instanceof EntityPlayer && ItemTorchBandolier.isAutoFillOn(stack)) {
            ItemTorchBandolier.absorbTorches(stack, (EntityPlayer)entityIn);
        }
    }

    private static void absorbTorches(ItemStack stack, EntityPlayer player) {
        int maxTorches = ItemTorchBandolier.getMaxTorchCount(stack);
        if (ItemTorchBandolier.getTorchCount(stack) >= maxTorches) {
            return;
        }
        Item itemTorch = ItemTorchBandolier.getBlockPlaced(stack).func_199767_j();
        for (ItemStack invStack : PlayerUtils.getNonEmptyStacks((EntityPlayer)player, (boolean)true, (boolean)true, (boolean)false)) {
            if (invStack.func_77973_b() != itemTorch) continue;
            int current = ItemTorchBandolier.getTorchCount(stack);
            if (current + invStack.func_190916_E() > maxTorches) {
                ItemTorchBandolier.setTorchCount(stack, maxTorches);
                invStack.func_190918_g(maxTorches - current);
            } else {
                ItemTorchBandolier.setTorchCount(stack, current + invStack.func_190916_E());
                invStack.func_190920_e(0);
            }
            if (invStack.func_190916_E() > 0) continue;
            PlayerUtils.removeItem((EntityPlayer)player, (ItemStack)invStack);
        }
    }

    public static int absorbTorchesFromEntityItem(ItemStack bandolier, ItemStack blockStack) {
        int bandolierCount = ItemTorchBandolier.getTorchCount(bandolier);
        int maxTorches = ItemTorchBandolier.getMaxTorchCount(bandolier);
        int blockCount = blockStack.func_190916_E();
        if (bandolierCount + blockCount > maxTorches) {
            ItemTorchBandolier.setTorchCount(bandolier, maxTorches);
            return maxTorches - bandolierCount;
        }
        ItemTorchBandolier.setTorchCount(bandolier, bandolierCount + blockCount);
        return blockCount;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.field_70170_p.field_72995_K && playerIn.func_70093_af()) {
            boolean mode = !ItemTorchBandolier.isAutoFillOn(stack);
            ItemTorchBandolier.setAutoFill(stack, mode);
            String translationKey = "item.torchbandolier.torch_bandolier.autoFill." + (mode ? "on" : "off");
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(translationKey, new Object[0]), true);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        EntityPlayer player = context.func_195999_j();
        if (!(ItemTorchBandolier.getTorchCount(stack) > 0 || player != null && player.field_71075_bZ.field_75098_d)) {
            return EnumActionResult.PASS;
        }
        Block block = ItemTorchBandolier.getBlockPlaced(stack);
        if (block == null) {
            return EnumActionResult.PASS;
        }
        ItemStack fakeBlockStack = new ItemStack((IItemProvider)block);
        EnumActionResult result = block.func_199767_j().func_195939_a(new ItemUseContext(player, fakeBlockStack, context.func_195995_a(), context.func_196000_l(), context.func_195997_m(), context.func_195993_n(), context.func_195994_o()));
        if (result == EnumActionResult.SUCCESS && !player.field_71075_bZ.field_75098_d) {
            ItemTorchBandolier.setTorchCount(stack, ItemTorchBandolier.getTorchCount(stack) - 1);
        }
        return result;
    }

    public ActionResult<ItemStack> onItemLeftClickSL(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_70093_af() && ItemTorchBandolier.getTorchCount(stack) > 0) {
            Block block = ItemTorchBandolier.getBlockPlaced(stack);
            if (block == null) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            ItemStack toDrop = new ItemStack((IItemProvider)block);
            toDrop.func_190920_e(Math.min(ItemTorchBandolier.getTorchCount(stack), toDrop.func_77976_d()));
            ItemTorchBandolier.setTorchCount(stack, ItemTorchBandolier.getTorchCount(stack) - toDrop.func_190916_E());
            Vec3d vec = player.func_70040_Z().func_186678_a(2.0);
            EntityItem entity = new EntityItem(world, player.field_70165_t + vec.field_72450_a, player.field_70163_u + 1.0 + vec.field_72448_b, player.field_70161_v + vec.field_72449_c, toDrop);
            vec = vec.func_186678_a(-0.125);
            entity.field_70159_w = vec.field_72450_a;
            entity.field_70181_x = vec.field_72448_b;
            entity.field_70179_y = vec.field_72449_c;
            EntityHelper.safeSpawn((Entity)entity);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((IItemProvider)this);
        ItemStack full = new ItemStack((IItemProvider)this);
        ItemTorchBandolier.setTorchCount(full, ItemTorchBandolier.getMaxTorchCount(full));
        items.add((Object)empty);
        items.add((Object)full);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean autoFill = ItemTorchBandolier.isAutoFillOn(stack);
        int torches = ItemTorchBandolier.getTorchCount(stack);
        int maxTorches = ItemTorchBandolier.getMaxTorchCount(stack);
        Block block = ItemTorchBandolier.getBlockPlaced(stack);
        String key = "item.torchbandolier.torch_bandolier";
        ITextComponent blockName = block != null ? block.func_200291_n() : new TextComponentTranslation(key + ".empty", new Object[0]);
        tooltip.add((ITextComponent)new TextComponentTranslation(key + ".blockPlaced", new Object[]{blockName}));
        tooltip.add((ITextComponent)new TextComponentTranslation(key + ".count", new Object[]{torches, maxTorches}));
        tooltip.add((ITextComponent)new TextComponentTranslation(key + ".autoFill." + (autoFill ? "on" : "off"), new Object[0]));
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int max = ItemTorchBandolier.getMaxTorchCount(stack);
        if (max <= 0) {
            return 1.0;
        }
        return 1.0 - (double)ItemTorchBandolier.getTorchCount(stack) / (double)max;
    }

    @Nullable
    private static Block getBlockPlaced(ItemStack stack) {
        return Blocks.field_150478_aa;
    }

    private static NBTTagCompound getData(ItemStack stack) {
        return stack.func_190925_c(NBT_ROOT);
    }

    private static int getTorchCount(ItemStack stack) {
        return ItemTorchBandolier.getData(stack).func_74762_e(NBT_COUNT);
    }

    private static void setTorchCount(ItemStack stack, int value) {
        ItemTorchBandolier.getData(stack).func_74768_a(NBT_COUNT, value);
    }

    private static int getMaxTorchCount(ItemStack stack) {
        return (Integer)Config.GENERAL.maxTorchCount.get();
    }

    private static boolean isAutoFillOn(ItemStack stack) {
        return ItemTorchBandolier.getData(stack).func_74767_n(NBT_AUTO_FILL);
    }

    private static void setAutoFill(ItemStack stack, boolean value) {
        ItemTorchBandolier.getData(stack).func_74757_a(NBT_AUTO_FILL, value);
    }
}

