/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.core.conversion;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.conversion.AnnotationUtils;
import com.electronwill.nightconfig.core.conversion.Converter;
import com.electronwill.nightconfig.core.conversion.ForceBreakdown;
import com.electronwill.nightconfig.core.conversion.ReflectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class ObjectConverter {
    private final boolean bypassTransient;
    private final boolean bypassFinal;

    public ObjectConverter(boolean bypassTransient, boolean bypassFinal) {
        this.bypassTransient = bypassTransient;
        this.bypassFinal = bypassFinal;
    }

    public ObjectConverter() {
        this(false, true);
    }

    public void toConfig(Object o, Config destination) {
        Objects.requireNonNull(o, "The object must not be null.");
        Objects.requireNonNull(destination, "The config must not be null.");
        Class<?> clazz = o.getClass();
        List<String> annotatedPath = AnnotationUtils.getPath(clazz);
        if (annotatedPath != null) {
            destination = (Config)destination.getRaw(annotatedPath);
        }
        this.convertToConfig(o, clazz, destination);
    }

    public void toConfig(Class<?> clazz, Config destination) {
        Objects.requireNonNull(destination, "The config must not be null.");
        List<String> annotatedPath = AnnotationUtils.getPath(clazz);
        if (annotatedPath != null) {
            destination = (Config)destination.getRaw(annotatedPath);
        }
        this.convertToConfig(null, clazz, destination);
    }

    public <C extends Config> C toConfig(Object o, Supplier<C> destinationSupplier) {
        Config destination = (Config)destinationSupplier.get();
        this.toConfig(o, destination);
        return (C)destination;
    }

    public <C extends Config> C toConfig(Class<?> clazz, Supplier<C> destinationSupplier) {
        Config destination = (Config)destinationSupplier.get();
        this.toConfig(clazz, destination);
        return (C)destination;
    }

    public void toObject(UnmodifiableConfig config, Object destination) {
        Objects.requireNonNull(config, "The config must not be null.");
        Objects.requireNonNull(destination, "The object must not be null.");
        Class<?> clazz = destination.getClass();
        List<String> annotatedPath = AnnotationUtils.getPath(clazz);
        if (annotatedPath != null) {
            config = (UnmodifiableConfig)config.getRaw(annotatedPath);
        }
        this.convertToObject(config, destination, clazz);
    }

    public <O> O toObject(UnmodifiableConfig config, Supplier<O> destinationSupplier) {
        O destination = destinationSupplier.get();
        this.toObject(config, destination);
        return destination;
    }

    private void convertToConfig(Object object, Class<?> clazz, Config destination) {
        for (Field field : clazz.getDeclaredFields()) {
            Object value;
            int fieldModifiers = field.getModifiers();
            if (object == null && Modifier.isStatic(fieldModifiers) || !this.bypassTransient && Modifier.isTransient(fieldModifiers)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException("Unable to parse the field " + field, e);
            }
            AnnotationUtils.checkField(field, value);
            Converter<Object, Object> converter = AnnotationUtils.getConverter(field);
            if (converter != null) {
                value = converter.convertFromField(value);
            }
            List<String> path = AnnotationUtils.getPath(field);
            if (value != null && (!destination.configFormat().supportsType(value.getClass()) || field.isAnnotationPresent(ForceBreakdown.class))) {
                Config subConfig = destination.createSubConfig();
                this.convertToConfig(value, field.getType(), subConfig);
                destination.set(path, (Object)subConfig);
                continue;
            }
            destination.set(path, value);
        }
    }

    private void convertToObject(UnmodifiableConfig config, Object object, Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            int fieldModifiers = field.getModifiers();
            if (object == null && Modifier.isStatic(fieldModifiers) || !this.bypassFinal && Modifier.isFinal(fieldModifiers)) continue;
            field.setAccessible(true);
            if (!this.bypassTransient && Modifier.isTransient(fieldModifiers)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            List<String> path = AnnotationUtils.getPath(field);
            Object value = config.get(path);
            Converter<Object, Object> converter = AnnotationUtils.getConverter(field);
            if (converter != null) {
                value = converter.convertToField(value);
            }
            Class<?> fieldType = field.getType();
            try {
                if (value instanceof UnmodifiableConfig && !fieldType.isAssignableFrom(value.getClass())) {
                    Object fieldValue = field.get(object);
                    if (fieldValue == null) {
                        fieldValue = this.createInstance(fieldType);
                        field.set(object, fieldValue);
                        this.convertToObject((UnmodifiableConfig)value, fieldValue, field.getType());
                        continue;
                    }
                    if (AnnotationUtils.mustPreserve(field, clazz)) continue;
                    this.convertToObject((UnmodifiableConfig)value, fieldValue, field.getType());
                    continue;
                }
                if (value == null && AnnotationUtils.mustPreserve(field, clazz)) {
                    AnnotationUtils.checkField(field, field.get(object));
                    continue;
                }
                AnnotationUtils.checkField(field, value);
                field.set(object, value);
            }
            catch (ReflectiveOperationException ex) {
                throw new ReflectionException("Unable to work with field " + field, ex);
            }
        }
    }

    private <T> T createInstance(Class<T> tClass) {
        try {
            Constructor<T> constructor = tClass.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException("Unable to create an instance of " + tClass, ex);
        }
    }
}

