/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.debug;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.lib.SilentLib;
import org.apache.logging.log4j.Logger;

public final class DataDump {
    private static final String REGISTRY_NAME_IS_NULL = "Registry name is null! This indicates a broken mod and is a serious problem!";
    private static final String SEPARATOR = "--------------------------------------------------------------------------------";

    private DataDump() {
        throw new IllegalAccessError("Utility class");
    }

    public static void dumpBlocks() {
        SilentLib.LOGGER.info(SEPARATOR);
        ArrayList<String> lines = new ArrayList<String>();
        for (Block block : ForgeRegistries.BLOCKS) {
            try {
                ResourceLocation name = Objects.requireNonNull(block.getRegistryName(), REGISTRY_NAME_IS_NULL);
                String translatedName = block.func_200291_n().func_150254_d();
                lines.add(String.format("%-60s %-60s", name, translatedName));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on block: {} ***", (Object)block);
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        lines.sort(String::compareToIgnoreCase);
        lines.forEach(arg_0 -> ((Logger)SilentLib.LOGGER).info(arg_0));
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpEnchantments() {
        SilentLib.LOGGER.info(SEPARATOR);
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            try {
                ResourceLocation name = Objects.requireNonNull(ench.getRegistryName(), REGISTRY_NAME_IS_NULL);
                String translatedName = ench.func_200305_d(1).func_150254_d().replaceFirst(" I$", "");
                String type = ench.field_77351_y == null ? "null" : ench.field_77351_y.name();
                SilentLib.LOGGER.info(String.format("%-30s %-40s type=%-10s", translatedName, name, type));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on enchantment: {} ***", (Object)ench);
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpEntityList() {
        SilentLib.LOGGER.info(SEPARATOR);
        ArrayList list = Lists.newArrayList();
        for (EntityType entry : ForgeRegistries.ENTITIES) {
            try {
                ResourceLocation name = Objects.requireNonNull(entry.getRegistryName(), REGISTRY_NAME_IS_NULL);
                Class clazz = entry.func_201760_c();
                String oldName = entry.func_210760_d();
                list.add(String.format("%-30s   %-40s %-40s", oldName, name, clazz));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on entity: {} ***", (Object)entry.func_201760_c());
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        list.sort(String::compareToIgnoreCase);
        list.forEach(arg_0 -> ((Logger)SilentLib.LOGGER).info(arg_0));
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpItems() {
        SilentLib.LOGGER.info(SEPARATOR);
        ArrayList<String> lines = new ArrayList<String>();
        for (Item item : ForgeRegistries.ITEMS) {
            try {
                ResourceLocation name = Objects.requireNonNull(item.getRegistryName(), REGISTRY_NAME_IS_NULL);
                ItemStack stack = new ItemStack((IItemProvider)item);
                String translatedName = stack.func_200301_q().func_150254_d();
                lines.add(String.format("%-60s %-60s", name, translatedName));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on item: {} ***", (Object)item);
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        lines.forEach(arg_0 -> ((Logger)SilentLib.LOGGER).info(arg_0));
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpPotionEffects() {
        SilentLib.LOGGER.info(SEPARATOR);
        for (Potion pot : ForgeRegistries.POTIONS) {
            try {
                ResourceLocation name = Objects.requireNonNull(pot.getRegistryName(), REGISTRY_NAME_IS_NULL);
                SilentLib.LOGGER.info(String.format("%-30s %-40s", pot.func_76393_a(), name));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on potion: {} ***", (Object)pot);
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpRecipes() {
    }
}

