/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.PlayerUtils;

@ParametersAreNonnullByDefault
public final class InitialSpawnItems {
    private static final InitialSpawnItems INSTANCE = new InitialSpawnItems();
    private static final String NBT_KEY = "silentlib.SpawnItemsGiven";
    private final Map<ResourceLocation, Supplier<ItemStack>> spawnItems = new HashMap<ResourceLocation, Supplier<ItemStack>>();

    private InitialSpawnItems() {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
    }

    public static void add(ResourceLocation key, Supplier<ItemStack> stack) {
        InitialSpawnItems.INSTANCE.spawnItems.put(key, stack);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.getPlayer();
        NBTTagCompound givenItems = PlayerUtils.getPersistedDataSubcompound(player, NBT_KEY);
        this.spawnItems.forEach((key, supplier) -> {
            ItemStack stack;
            String nbtKey = key.toString().replace(':', '.');
            if (!givenItems.func_74767_n(nbtKey) && !(stack = (ItemStack)supplier.get()).func_190926_b()) {
                SilentLib.LOGGER.debug("Giving player {} spawn item \"{}\" = {}", (Object)player.func_200200_C_(), (Object)nbtKey, (Object)stack);
                PlayerUtils.giveItem(player, stack);
                givenItems.func_74757_a(nbtKey, true);
            }
        });
    }
}

