/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IEnumItems<E extends Enum<E>, I extends Item>
extends IStringSerializable {
    @Nonnull
    public E getEnum();

    @Nonnull
    public I getItem();

    @Nonnull
    default public ItemStack getStack() {
        return new ItemStack(this.getItem());
    }

    @Nonnull
    default public ItemStack getStack(int amount) {
        return new ItemStack(this.getItem(), amount);
    }

    @Nonnull
    default public String func_176610_l() {
        String prefix = this.getNamePrefix();
        return (!prefix.isEmpty() ? prefix + "_" : "") + ((Enum)this.getEnum()).name().toLowerCase(Locale.ROOT);
    }

    @Nonnull
    default public String getNamePrefix() {
        return "";
    }

    public static class RegistrationHelper {
        private final String modId;

        public RegistrationHelper(String modId) {
            this.modId = modId;
        }

        public void registerItems(IEnumItems ... items) {
            for (IEnumItems item : items) {
                this.safeSetRegistryName((IForgeRegistryEntry<?>)item.getItem(), item.func_176610_l());
                ForgeRegistries.ITEMS.register(item.getItem());
            }
        }

        public <E extends Enum<E>> void registerBlocksGenericEnum(Function<E, Block> blockGetter, Function<E, String> nameGetter, Class<E> enumClass) {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                String name = nameGetter.apply(e);
                Block block = blockGetter.apply(e);
                this.safeSetRegistryName((IForgeRegistryEntry<?>)block, name);
                ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
                ItemBlock item = new ItemBlock(block, new Item.Properties());
                this.safeSetRegistryName((IForgeRegistryEntry<?>)item, name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            }
        }

        public <E extends Enum<E>> void registerItemsGenericEnum(Function<E, Item> itemGetter, Function<E, String> name, Class<E> enumClass) {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                Item item = itemGetter.apply(e);
                this.safeSetRegistryName((IForgeRegistryEntry<?>)item, name.apply(e));
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            }
        }

        private void safeSetRegistryName(IForgeRegistryEntry<?> obj, String name) {
            if (obj.getRegistryName() == null) {
                obj.setRegistryName(new ResourceLocation(this.modId, name));
            }
        }
    }
}

