/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.PlayerUtils;

public class ItemLootContainer
extends Item {
    private static final String NBT_ROOT = "silentlib.LootContainer";
    private static final String NBT_LOOT_TABLE = "LootTable";
    private static final boolean DEFAULT_LIST_ITEMS_RECEIVED = true;
    private final ResourceLocation defaultLootTable;
    private final boolean listItemsReceived;

    public ItemLootContainer(ResourceLocation defaultLootTable) {
        this(defaultLootTable, true, new Item.Properties());
    }

    public ItemLootContainer(ResourceLocation defaultLootTable, boolean listItemsReceived) {
        this(defaultLootTable, listItemsReceived, new Item.Properties());
    }

    public ItemLootContainer(ResourceLocation defaultLootTable, Item.Properties properties) {
        this(defaultLootTable, true, properties);
    }

    public ItemLootContainer(ResourceLocation defaultLootTable, boolean listItemsReceived, Item.Properties properties) {
        super(properties);
        this.defaultLootTable = defaultLootTable;
        this.listItemsReceived = listItemsReceived;
    }

    public ItemStack getStack() {
        return this.getStack(this.defaultLootTable);
    }

    public ItemStack getStack(ResourceLocation lootTable) {
        ItemStack result = new ItemStack((IItemProvider)this);
        ItemLootContainer.getData(result).func_74778_a(NBT_LOOT_TABLE, lootTable.toString());
        return result;
    }

    protected static NBTTagCompound getData(ItemStack stack) {
        return stack.func_190925_c(NBT_ROOT);
    }

    protected ResourceLocation getLootTable(ItemStack stack) {
        String str;
        ResourceLocation table;
        NBTTagCompound tags = ItemLootContainer.getData(stack);
        if (tags.func_74764_b(NBT_LOOT_TABLE) && (table = ResourceLocation.func_208304_a((String)(str = tags.func_74779_i(NBT_LOOT_TABLE)))) != null) {
            return table;
        }
        return this.defaultLootTable;
    }

    public static void setLootTable(ItemStack stack, ResourceLocation lootTable) {
        ItemLootContainer.getData(stack).func_74778_a(NBT_LOOT_TABLE, lootTable.toString());
    }

    protected Collection<ItemStack> getLootDrops(ItemStack heldItem, EntityPlayerMP player) {
        ResourceLocation lootTable = this.getLootTable(heldItem);
        MinecraftServer server = player.field_70170_p.func_73046_m();
        if (server == null) {
            return ImmutableList.of();
        }
        LootContext lootContext = new LootContext.Builder(player.func_71121_q()).func_186472_a((Entity)player).func_186470_a((EntityPlayer)player).func_186469_a(player.func_184817_da()).func_186471_a();
        return ImmutableList.copyOf((Collection)server.func_200249_aQ().func_186521_a(lootTable).func_186462_a(player.func_70681_au(), lootContext));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!flagIn.func_194127_a()) {
            return;
        }
        ITextComponent textTableName = new TextComponentString(this.getLootTable(stack).toString()).func_211708_a(TextFormatting.WHITE);
        tooltip.add(new TextComponentTranslation("item.silentlib.lootContainer.table", new Object[]{textTableName}).func_211708_a(TextFormatting.BLUE));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (!(playerIn instanceof EntityPlayerMP)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)playerIn;
        Collection<ItemStack> lootDrops = this.getLootDrops(heldItem, playerMP);
        if (lootDrops.isEmpty()) {
            SilentLib.LOGGER.warn("ItemLootContainer has no drops? {}", (Object)heldItem);
        }
        lootDrops.forEach(stack -> {
            PlayerUtils.giveItem((EntityPlayer)playerMP, stack);
            if (this.listItemsReceived) {
                ItemLootContainer.listItemReceivedInChat(playerMP, stack);
            }
        });
        playerMP.field_70170_p.func_184148_a(null, playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((playerMP.func_70681_au().nextFloat() - playerMP.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        heldItem.func_190918_g(1);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    private static void listItemReceivedInChat(EntityPlayerMP playerMP, ItemStack stack) {
        TextComponentTranslation itemReceivedText = new TextComponentTranslation("item.silentlib.lootContainer.itemReceived", new Object[]{stack.func_190916_E(), stack.func_200301_q()});
        playerMP.func_145747_a((ITextComponent)itemReceivedText);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.getStack());
        }
    }
}

