/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;

public final class EnumUtils {
    private EnumUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static <E extends Enum<E>> E byIndex(int value, E defaultValue, Function<E, Integer> getter) {
        for (Enum e : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
            if (getter.apply(e) != value) continue;
            return (E)e;
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> E byName(String name, E defaultValue) {
        for (Enum e : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(name)) continue;
            return (E)e;
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> E byOrdinal(int ordinal, E defaultValue) {
        Enum[] enumConstants = (Enum[])defaultValue.getDeclaringClass().getEnumConstants();
        if (ordinal >= 0 && ordinal < enumConstants.length) {
            return (E)enumConstants[ordinal];
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> boolean validate(@Nullable Object obj, Class<E> enumClass) {
        if (obj != null) {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase(obj.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static <E extends Enum<E>> Supplier<E> defineEnumFix(ForgeConfigSpec.Builder builder, String path, E defaultValue) {
        ForgeConfigSpec.ConfigValue configValue = builder.define(path, defaultValue::name, o -> EnumUtils.validate(o, defaultValue.getDeclaringClass()));
        return () -> EnumUtils.byName((String)configValue.get(), defaultValue);
    }

    public static <E extends Enum<E>> Supplier<E> defineEnumFix(ForgeConfigSpec.Builder builder, String path, E defaultValue, Set<E> validValues) {
        ForgeConfigSpec.ConfigValue configValue = builder.define(path, defaultValue::name, o -> EnumUtils.validate(o, defaultValue.getDeclaringClass()) && validValues.contains(o));
        return () -> EnumUtils.byName((String)configValue.get(), defaultValue);
    }
}

