/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.SilentLib;

public final class ModelGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private ModelGenerator() {
        throw new IllegalAccessError("Utility class");
    }

    public static void create(Block block) {
        ModelGenerator.create(BlockBuilder.create(block));
    }

    public static void create(BlockBuilder builder) {
        ResourceLocation name = builder.blockName;
        ModelGenerator.writeFile(builder.buildBlockState(), "blockstates", name);
        ModelGenerator.writeFile(builder.buildBlockModel(), "models/block", name);
        ModelGenerator.writeFile(builder.buildItemModel(), "models/item", name);
    }

    public static void create(Item item) {
        ModelGenerator.create(ItemBuilder.create(item));
    }

    public static void create(ItemBuilder builder) {
        ResourceLocation name = builder.itemName;
        ModelGenerator.writeFile(builder.build(), "models/item", name);
    }

    private static void writeFile(JsonObject json, String subdir, ResourceLocation name) {
        String fileName = name.func_110623_a();
        String dirPath = "output/assets/" + name.func_110624_b() + "/" + subdir;
        File output = new File(dirPath, fileName + ".json");
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            SilentLib.LOGGER.error("Could not create directory: {}", (Object)output.getParent());
            return;
        }
        try (FileWriter writer = new FileWriter(output);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
            SilentLib.LOGGER.info("Wrote model file {}", (Object)output.getAbsolutePath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final class ItemBuilder {
        private final Item item;
        private final ResourceLocation itemName;
        private String parentModel = "item/generated";
        private final List<ResourceLocation> itemTextures = new ArrayList<ResourceLocation>();
        private String comment = "";

        private ItemBuilder(Item item) {
            this.item = item;
            this.itemName = Objects.requireNonNull(this.item.getRegistryName());
        }

        public static ItemBuilder create(Item item) {
            return new ItemBuilder(item);
        }

        public ItemBuilder parent(String parentModel) {
            this.parentModel = parentModel;
            return this;
        }

        public ItemBuilder texture(String texture) {
            return this.texture(new ResourceLocation(this.itemName.func_110624_b(), "item/" + texture));
        }

        public ItemBuilder texture(ResourceLocation texturePath) {
            this.itemTextures.add(texturePath);
            return this;
        }

        public ItemBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        private String getDefaultTexture() {
            return this.itemName.func_110624_b() + ":item/" + this.itemName.func_110623_a();
        }

        JsonObject build() {
            JsonObject json = new JsonObject();
            if (!this.comment.isEmpty()) {
                json.addProperty("__comment__", this.comment);
            }
            json.addProperty("parent", this.parentModel);
            if (this.itemTextures.isEmpty() && !(this.item instanceof ItemBlock)) {
                JsonObject textures = new JsonObject();
                textures.addProperty("layer0", this.getDefaultTexture());
                json.add("textures", (JsonElement)textures);
            } else if (!this.itemTextures.isEmpty()) {
                JsonObject textures = new JsonObject();
                for (int i = 0; i < this.itemTextures.size(); ++i) {
                    textures.addProperty("layer" + i, this.itemTextures.get(i).toString());
                }
                json.add("textures", (JsonElement)textures);
            }
            return json;
        }
    }

    public static final class BlockBuilder {
        private final Block block;
        private final ResourceLocation blockName;
        private String comment = "";
        private Map<String, String> variants;
        private String parentModel = "block/cube_all";
        private final Map<String, ResourceLocation> blockTextures = new LinkedHashMap<String, ResourceLocation>();
        private ItemBuilder itemBuilder;
        private ResourceLocation defaultItemModel;
        private ResourceLocation defaultItemTexture;

        private BlockBuilder(Block block) {
            this.block = block;
            this.blockName = this.block.getRegistryName();
        }

        public static BlockBuilder create(Block block) {
            return new BlockBuilder(block);
        }

        public BlockBuilder variant(String key, String model) {
            return this.variant(key, new ResourceLocation(this.blockName.func_110624_b(), "block/" + model));
        }

        public BlockBuilder variant(String key, ResourceLocation modelPath) {
            if (this.variants == null) {
                this.variants = new LinkedHashMap<String, String>();
            }
            this.variants.put(key, modelPath.toString());
            if (this.defaultItemModel == null) {
                this.defaultItemModel = modelPath;
            }
            return this;
        }

        public BlockBuilder parent(String parentModel) {
            this.parentModel = parentModel;
            return this;
        }

        public BlockBuilder texture(String texture) {
            return this.texture("all", texture);
        }

        public BlockBuilder texture(ResourceLocation texturePath) {
            return this.texture("all", texturePath);
        }

        public BlockBuilder texture(String key, String texture) {
            return this.texture(key, new ResourceLocation(this.blockName.func_110624_b(), "block/" + texture));
        }

        public BlockBuilder texture(String key, ResourceLocation texturePath) {
            this.blockTextures.put(key, texturePath);
            if (this.defaultItemTexture == null) {
                this.defaultItemTexture = texturePath;
            }
            return this;
        }

        public BlockBuilder item(ItemBuilder builder) {
            this.itemBuilder = builder;
            return this;
        }

        public BlockBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        private String getDefaultModel() {
            return this.blockName.func_110624_b() + ":block/" + this.blockName.func_110623_a();
        }

        private String getDefaultTexture() {
            return this.blockName.func_110624_b() + ":block/" + this.blockName.func_110623_a();
        }

        private ItemBuilder getDefaultItemBuilder() {
            return ItemBuilder.create(this.block.func_199767_j()).parent(this.defaultItemModel == null ? this.getDefaultModel() : this.defaultItemModel.toString());
        }

        JsonObject buildBlockState() {
            JsonObject json = new JsonObject();
            if (!this.comment.isEmpty()) {
                json.addProperty("__comment__", this.comment);
            }
            JsonObject variantsJson = new JsonObject();
            if (this.variants == null || this.variants.isEmpty()) {
                JsonObject model = new JsonObject();
                model.addProperty("model", this.getDefaultModel());
                variantsJson.add("", (JsonElement)model);
            } else {
                this.variants.forEach((key, val) -> {
                    JsonObject model = new JsonObject();
                    model.addProperty("model", val);
                    variantsJson.add(key, (JsonElement)model);
                });
            }
            json.add("variants", (JsonElement)variantsJson);
            return json;
        }

        JsonObject buildBlockModel() {
            JsonObject json = new JsonObject();
            json.addProperty("parent", this.parentModel);
            JsonObject textures = new JsonObject();
            if (this.blockTextures.isEmpty()) {
                textures.addProperty("all", this.getDefaultTexture());
            } else {
                this.blockTextures.forEach((key, val) -> textures.addProperty(key, val.toString()));
            }
            json.add("textures", (JsonElement)textures);
            return json;
        }

        JsonObject buildItemModel() {
            return this.itemBuilder != null ? this.itemBuilder.build() : this.getDefaultItemBuilder().build();
        }
    }
}

