/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.torchbandolier.init;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.torchbandolier.TorchBandolier;
import net.silentchaos512.torchbandolier.item.TorchBandolierItem;

public final class ModItems {
    public static TorchBandolierItem emptyTorchBandolier;
    public static TorchBandolierItem torchBandolier;
    private static final Map<Item, TorchBandolierItem> TORCH_BANDOLIERS;

    private ModItems() {
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        if (!event.getName().equals((Object)ForgeRegistries.ITEMS.getRegistryName())) {
            return;
        }
        emptyTorchBandolier = new TorchBandolierItem((Block)null);
        torchBandolier = new TorchBandolierItem(Blocks.field_150478_aa);
        ModItems.registerTorchBandolier("empty_torch_bandolier", emptyTorchBandolier);
        ModItems.registerTorchBandolier("torch_bandolier", torchBandolier);
        ModItems.registerTorchBandolier("stone_torch_bandolier", new TorchBandolierItem(ModItems.getTorch(new ResourceLocation("silentgear:stone_torch"), new ResourceLocation("slurpiesdongles:stone_torch"))));
        if (TorchBandolier.isDevBuild()) {
            ModItems.registerTorchBandolier("test_item", new TorchBandolierItem(Blocks.field_150426_aN));
        }
    }

    @Nullable
    private static Block getTorch(ResourceLocation ... possibleIds) {
        for (ResourceLocation id : possibleIds) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (block == null) continue;
            return block;
        }
        return null;
    }

    @Nullable
    public static TorchBandolierItem getTorchBandolier(IItemProvider torch) {
        return TORCH_BANDOLIERS.get(torch.func_199767_j());
    }

    public static void registerTorchBandolier(ResourceLocation name, TorchBandolierItem item) {
        Block torch = item.getTorchBlock();
        if (torch != null) {
            TORCH_BANDOLIERS.put(torch.func_199767_j(), item);
        }
        ModItems.register(name, item);
    }

    private static void registerTorchBandolier(String name, TorchBandolierItem item) {
        ModItems.registerTorchBandolier(TorchBandolier.getId(name), item);
    }

    private static void register(ResourceLocation name, Item item) {
        if (item.getRegistryName() == null) {
            item.setRegistryName(name);
        }
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public static Stream<Map.Entry<Item, TorchBandolierItem>> getTorchBandolierPairs() {
        return TORCH_BANDOLIERS.entrySet().stream();
    }

    static {
        TORCH_BANDOLIERS = new HashMap<Item, TorchBandolierItem>();
    }
}

