/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.torchbandolier.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.lib.item.FakeItemUseContext;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.torchbandolier.TorchBandolier;
import net.silentchaos512.torchbandolier.config.Config;
import net.silentchaos512.torchbandolier.init.ModItems;
import net.silentchaos512.utils.Lazy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TorchBandolierItem
extends Item {
    private static final String NBT_ROOT = "TorchBandolier";
    private static final String NBT_AUTO_FILL = "AutoFill";
    private static final String NBT_COUNT = "Count";
    private static final int ABSORB_DELAY = 20;
    private final Lazy<Block> torchBlock;

    public TorchBandolierItem(@Nullable Block torchBlock) {
        this(() -> torchBlock);
    }

    public TorchBandolierItem(Supplier<Block> torchBlock) {
        super(new Item.Properties().func_200917_a(1).setNoRepair().func_200916_a(TorchBandolier.ITEM_GROUP));
        this.torchBlock = Lazy.of(torchBlock);
    }

    @Nullable
    public Block getTorchBlock() {
        return (Block)this.torchBlock.get();
    }

    public static ItemStack createStack(TorchBandolierItem item, int torchCount) {
        ItemStack result = new ItemStack((IItemProvider)item);
        TorchBandolierItem.setTorchCount(result, torchCount);
        TorchBandolierItem.setAutoFill(result, true);
        return result;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 20L == 0L && entityIn instanceof PlayerEntity && TorchBandolierItem.isAutoFillOn(stack)) {
            this.absorbTorches(stack, (PlayerEntity)entityIn);
        }
    }

    private void absorbTorches(ItemStack stack, PlayerEntity player) {
        int maxTorches = TorchBandolierItem.getMaxTorchCount(stack);
        Block torch = this.getTorchBlock();
        if (torch == null || torch instanceof AirBlock || TorchBandolierItem.getTorchCount(stack) >= maxTorches) {
            return;
        }
        Item itemTorch = torch.func_199767_j();
        for (ItemStack invStack : PlayerUtils.getNonEmptyStacks((PlayerEntity)player, (boolean)true, (boolean)true, (boolean)false)) {
            if (invStack.func_77973_b() != itemTorch) continue;
            int current = TorchBandolierItem.getTorchCount(stack);
            if (current + invStack.func_190916_E() > maxTorches) {
                TorchBandolierItem.setTorchCount(stack, maxTorches);
                invStack.func_190918_g(maxTorches - current);
            } else {
                TorchBandolierItem.setTorchCount(stack, current + invStack.func_190916_E());
                invStack.func_190920_e(0);
            }
            if (invStack.func_190916_E() > 0) continue;
            PlayerUtils.removeItem((PlayerEntity)player, (ItemStack)invStack);
        }
    }

    public static int absorbTorchesFromItemEntity(ItemStack bandolier, ItemStack blockStack) {
        int bandolierCount = TorchBandolierItem.getTorchCount(bandolier);
        int maxTorches = TorchBandolierItem.getMaxTorchCount(bandolier);
        int blockCount = blockStack.func_190916_E();
        if (bandolierCount + blockCount > maxTorches) {
            TorchBandolierItem.setTorchCount(bandolier, maxTorches);
            return maxTorches - bandolierCount;
        }
        TorchBandolierItem.setTorchCount(bandolier, bandolierCount + blockCount);
        return blockCount;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        Block torch = this.getTorchBlock();
        if (torch == null || torch instanceof AirBlock) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.field_70170_p.field_72995_K && playerIn.func_70093_af()) {
            boolean mode = !TorchBandolierItem.isAutoFillOn(stack);
            TorchBandolierItem.setAutoFill(stack, mode);
            String translationKey = "item.torchbandolier.torch_bandolier.autoFill." + (mode ? "on" : "off");
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]), true);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        boolean consumeTorch;
        Block torch = this.getTorchBlock();
        if (torch == null || torch instanceof AirBlock) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        boolean bl = consumeTorch = player == null || !player.field_71075_bZ.field_75098_d;
        if (TorchBandolierItem.getTorchCount(stack) <= 0 && consumeTorch) {
            return ActionResultType.PASS;
        }
        ItemStack fakeBlockStack = new ItemStack((IItemProvider)torch);
        ActionResultType result = fakeBlockStack.func_196084_a((ItemUseContext)new FakeItemUseContext(context, fakeBlockStack));
        if (result == ActionResultType.SUCCESS && consumeTorch) {
            TorchBandolierItem.setTorchCount(stack, TorchBandolierItem.getTorchCount(stack) - 1);
        }
        if (TorchBandolierItem.getTorchCount(stack) == 0 && player != null) {
            player.func_174820_d(TorchBandolierItem.getItemSlot(player, stack), new ItemStack((IItemProvider)ModItems.emptyTorchBandolier));
        }
        return result;
    }

    private static int getItemSlot(PlayerEntity player, ItemStack stack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack1 = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack1.func_190926_b() || stack.func_77973_b() != stack1.func_77973_b() || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stack1)) continue;
            return i;
        }
        return -1;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab) || this.getTorchBlock() instanceof AirBlock) {
            return;
        }
        items.add((Object)TorchBandolierItem.createStack(this, TorchBandolierItem.getMaxTorchCount()));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String key = "item.torchbandolier.torch_bandolier";
        Block torch = this.getTorchBlock();
        TranslationTextComponent blockName = torch != null && !(torch instanceof AirBlock) ? torch.func_200291_n() : new TranslationTextComponent(key + ".empty", new Object[0]);
        tooltip.add((ITextComponent)new TranslationTextComponent(key + ".blockPlaced", new Object[]{blockName}));
        if (torch != null) {
            int torches = TorchBandolierItem.getTorchCount(stack);
            int maxTorches = TorchBandolierItem.getMaxTorchCount(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent(key + ".count", new Object[]{torches, maxTorches}));
            boolean autoFill = TorchBandolierItem.isAutoFillOn(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent(key + ".autoFill." + (autoFill ? "on" : "off"), new Object[0]));
        } else {
            tooltip.add(new TranslationTextComponent(key + ".emptyHint", new Object[0]).func_211708_a(TextFormatting.ITALIC));
        }
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getTorchBlock() != null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int max = TorchBandolierItem.getMaxTorchCount(stack);
        return max > 0 ? 1.0 - (double)TorchBandolierItem.getTorchCount(stack) / (double)max : 1.0;
    }

    private static CompoundNBT getData(ItemStack stack) {
        return stack.func_190925_c(NBT_ROOT);
    }

    public static int getTorchCount(ItemStack stack) {
        return TorchBandolierItem.getData(stack).func_74762_e(NBT_COUNT);
    }

    public static void setTorchCount(ItemStack stack, int value) {
        TorchBandolierItem.getData(stack).func_74768_a(NBT_COUNT, value);
    }

    public static int getMaxTorchCount() {
        return (Integer)Config.GENERAL.maxTorchCount.get();
    }

    public static int getMaxTorchCount(ItemStack stack) {
        return TorchBandolierItem.getMaxTorchCount();
    }

    public static boolean isAutoFillOn(ItemStack stack) {
        return TorchBandolierItem.getData(stack).func_74767_n(NBT_AUTO_FILL);
    }

    public static void setAutoFill(ItemStack stack, boolean value) {
        TorchBandolierItem.getData(stack).func_74757_a(NBT_AUTO_FILL, value);
    }
}

