/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.command.internal;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.silentchaos512.lib.network.internal.DisplayNBTPacket;
import net.silentchaos512.lib.network.internal.SilentLibNetwork;

public class DisplayNBTCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sl_nbt").requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"block").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(DisplayNBTCommand::runForBlock)))).then(Commands.func_197057_a((String)"entity").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(DisplayNBTCommand::runForEntity)))).then(Commands.func_197057_a((String)"item").executes(DisplayNBTCommand::runForItem))).executes(context -> {
            SilentLibNetwork.channel.sendTo((Object)new DisplayNBTPacket(), ((CommandSource)context.getSource()).func_197035_h().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            return 1;
        }));
    }

    private static int runForBlock(CommandContext<CommandSource> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.func_197274_b(context, (String)"pos");
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        TileEntity tileEntity = world.func_175625_s(pos);
        TranslationTextComponent title = new TranslationTextComponent(world.func_180495_p(pos).func_177230_c().func_149739_a(), new Object[0]);
        if (tileEntity != null) {
            DisplayNBTCommand.sendPacket(context, tileEntity.func_189515_b(new CompoundNBT()), (ITextComponent)title);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.silentlib.nbt.notBlockEntity", new Object[]{title}));
        return 0;
    }

    private static int runForEntity(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.func_197088_a(context, (String)"target");
        CompoundNBT nbt = entity.func_189511_e(new CompoundNBT());
        ITextComponent title = entity.func_145748_c_();
        DisplayNBTCommand.sendPacket(context, nbt, title);
        return 1;
    }

    private static int runForItem(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ItemStack stack = ((CommandSource)context.getSource()).func_197035_h().func_184614_ca();
        if (stack.func_190926_b()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.silentlib.nbt.noItemInHand", new Object[0]));
            return 0;
        }
        if (!stack.func_77942_o()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.silentlib.nbt.noItemTag", new Object[]{stack.func_200301_q()}));
            return 0;
        }
        DisplayNBTCommand.sendPacket(context, stack.func_196082_o(), stack.func_200301_q());
        return 1;
    }

    private static void sendPacket(CommandContext<CommandSource> context, CompoundNBT nbt, ITextComponent title) throws CommandSyntaxException {
        DisplayNBTPacket msg = new DisplayNBTPacket(nbt, DisplayNBTCommand.textOfNullable(title));
        NetworkManager netManager = ((CommandSource)context.getSource()).func_197035_h().field_71135_a.field_147371_a;
        SilentLibNetwork.channel.sendTo((Object)msg, netManager, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static ITextComponent textOfNullable(@Nullable ITextComponent text) {
        return text == null ? new StringTextComponent("null") : text;
    }
}

