/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.torchbandolier.crafting.recipe;

import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.torchbandolier.init.ModItems;
import net.silentchaos512.torchbandolier.item.TorchBandolierItem;

public final class ExtractTorchesRecipe
implements ICraftingRecipe {
    public static final IRecipeSerializer<ExtractTorchesRecipe> SERIALIZER = new SpecialRecipeSerializer(ExtractTorchesRecipe::new);
    private final ResourceLocation recipeId;

    private ExtractTorchesRecipe(ResourceLocation id) {
        this.recipeId = id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        StackList list = StackList.from((IInventory)inv);
        if (list.size() != 1) {
            return false;
        }
        ItemStack stack = list.uniqueMatch(s -> s.func_77973_b() instanceof TorchBandolierItem && ((TorchBandolierItem)s.func_77973_b()).getTorchBlock() != null);
        return !stack.func_190926_b();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack stack = StackList.from((IInventory)inv).uniqueOfType(TorchBandolierItem.class);
        TorchBandolierItem item = (TorchBandolierItem)stack.func_77973_b();
        Block block = item.getTorchBlock();
        int torchCount = TorchBandolierItem.getTorchCount(stack);
        int extractCount = Math.min(torchCount, 64);
        return new ItemStack((IItemProvider)block, extractCount);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item.func_77973_b() instanceof TorchBandolierItem) {
                ItemStack newBandolier;
                ItemStack torches = this.getCraftingResult(inv);
                int newTorchCount = TorchBandolierItem.getTorchCount(item) - torches.func_190916_E();
                if (newTorchCount > 0) {
                    newBandolier = TorchBandolierItem.createStack((TorchBandolierItem)item.func_77973_b(), newTorchCount);
                    TorchBandolierItem.setTorchCount(newBandolier, newTorchCount);
                    TorchBandolierItem.setAutoFill(newBandolier, false);
                } else {
                    newBandolier = new ItemStack((IItemProvider)ModItems.emptyTorchBandolier);
                }
                list.set(i, (Object)newBandolier);
                continue;
            }
            if (!item.hasContainerItem()) continue;
            list.set(i, (Object)item.getContainerItem());
        }
        return list;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 1;
    }
}

