/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.verdure.event;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import samebutdifferent.verdure.registry.VerdureBlocks;
import samebutdifferent.verdure.registry.VerdurePlacedFeatures;

@Mod.EventBusSubscriber(modid="verdure")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        String name = event.getName().m_135815_();
        switch (event.getCategory()) {
            case FOREST: {
                if (name.contains("birch")) {
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.BIRCH_DAISIES);
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_WILDFLOWERS);
                }
                if (name.equals("forest")) {
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.OAK_DAISIES);
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.BIRCH_DAISIES);
                }
                if (name.equals("flower_forest")) {
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_WILDFLOWERS);
                }
                builder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, VerdurePlacedFeatures.BOULDER_STONE);
                builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.MUSHROOM_SHELF);
                CommonEventHandler.addGrassyAreaFeatures(builder);
                break;
            }
            case PLAINS: {
                builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG);
                CommonEventHandler.addGrassyAreaFeatures(builder);
                break;
            }
            case RIVER: {
                builder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, VerdurePlacedFeatures.BOULDER_SLATE);
                break;
            }
            case JUNGLE: {
                builder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, VerdurePlacedFeatures.BOULDER_SLATE);
                builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG);
                CommonEventHandler.addGrassyAreaFeatures(builder);
                break;
            }
            case TAIGA: {
                if (!name.contains("old_growth")) {
                    builder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, VerdurePlacedFeatures.BOULDER_DIORITE);
                }
                builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.MUSHROOM_SHELF);
                CommonEventHandler.addGrassyAreaFeatures(builder);
                break;
            }
            case SAVANNA: {
                builder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, VerdurePlacedFeatures.BOULDER_GRANITE);
                builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG_SAVANNA);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_CLOVER);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_PEBBLES);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_ROCK);
                break;
            }
            case BEACH: {
                builder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, VerdurePlacedFeatures.BOULDER_ANDESITE);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_PEBBLES);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_ROCK);
                break;
            }
            case SWAMP: {
                builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH_SWAMP);
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.MUSHROOM_SHELF);
                CommonEventHandler.addGrassyAreaFeatures(builder);
                break;
            }
            case NETHER: {
                if (!name.contains("forest")) break;
                builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG_NETHER);
            }
        }
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.UNDERGROUND_MUSHROOM_SHELF);
    }

    private static void addGrassyAreaFeatures(BiomeGenerationSettingsBuilder builder) {
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_CLOVER);
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_PEBBLES);
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_ROCK);
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_DAISIES);
    }

    @SubscribeEvent
    public static void onPlace(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Player player = event.getPlayer();
        Level level = player.f_19853_;
        ItemStack stack = event.getItemStack();
        if ((level.m_8055_(event.getPos()).m_204336_(BlockTags.f_13106_) || level.m_8055_(event.getPos()).m_204336_(BlockTags.f_144274_) || level.m_8055_(event.getPos()).m_204336_(BlockTags.f_144266_)) && event.getFace().m_122434_().m_122480_() == Direction.Plane.HORIZONTAL && level.m_46859_(pos = event.getHitVec().m_82425_().m_142300_(event.getFace()))) {
            if (stack.m_150930_(Items.f_41952_)) {
                CommonEventHandler.placeMushroomShelf(event, player, level, pos, stack, (Block)VerdureBlocks.BROWN_MUSHROOM_SHELF.get());
            } else if (stack.m_150930_(Items.f_41953_)) {
                CommonEventHandler.placeMushroomShelf(event, player, level, pos, stack, (Block)VerdureBlocks.RED_MUSHROOM_SHELF.get());
            }
        }
    }

    private static void placeMushroomShelf(PlayerInteractEvent.RightClickBlock event, Player player, Level level, BlockPos pos, ItemStack stack, Block mushroomShelf) {
        BlockState state = mushroomShelf.m_5573_(new BlockPlaceContext(player, event.getHand(), stack, event.getHitVec()));
        level.m_46597_(pos, state);
        player.m_6674_(event.getHand());
        mushroomShelf.m_49966_().m_60734_().m_6402_(level, pos, state, (LivingEntity)player, stack);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, stack);
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
        SoundType soundtype = state.getSoundType((LevelReader)level, pos, (Entity)player);
        level.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }
}

