/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.mehvahdjukaar.advframes.client.AdvancementSelectScreen;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_UP = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<FrameType> TYPE = EnumProperty.func_177709_a((String)"type", FrameType.class);

    public AdvancementFrameBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(TYPE, (Comparable)((Object)FrameType.EMPTY)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d())).func_185904_a().func_76220_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext p_60558_) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
            case UP: 
        }
        return SHAPE_UP;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED, TYPE});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == ((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d() && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && fluidstate.func_206882_g() == 8));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockHitResult) {
        if (player instanceof ClientPlayerEntity) {
            ClientPlayerEntity p = (ClientPlayerEntity)player;
            TileEntity te = level.func_175625_s(pos);
            if (te instanceof AdvancementFrameBlockTile) {
                AdvancementFrameBlockTile tile = (AdvancementFrameBlockTile)te;
                if (tile.getAdvancement() == null) {
                    this.setScreen(tile, p);
                } else {
                    GameProfile owner = tile.getOwner();
                    if (owner != null && owner.getName() != null) {
                        DisplayInfo advancement = tile.getAdvancement();
                        if (player.func_226563_dT_()) {
                            player.func_146105_b(advancement.func_193222_b(), true);
                        } else {
                            IFormattableTextComponent name = new StringTextComponent(owner.getName()).func_240699_a_(TextFormatting.GOLD);
                            IFormattableTextComponent title = new StringTextComponent(advancement.func_192297_a().getString()).func_240699_a_(tile.getColor());
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("advancementframes.message", new Object[]{name, title}), true);
                        }
                    }
                }
            }
        }
        return ActionResultType.func_233537_a_((boolean)level.field_72995_K);
    }

    public void func_180633_a(World level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity te;
        if (entity instanceof ClientPlayerEntity && (te = level.func_175625_s(pos)) instanceof AdvancementFrameBlockTile) {
            this.setScreen((AdvancementFrameBlockTile)te, (ClientPlayerEntity)entity);
        }
        super.func_180633_a(level, pos, p_49849_, entity, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setScreen(AdvancementFrameBlockTile tile, ClientPlayerEntity player) {
        Minecraft minecraft = Minecraft.func_71410_x();
        AdvancementSelectScreen screen = new AdvancementSelectScreen(tile, player.field_71174_a.func_191982_f());
        Screen old = minecraft.field_71462_r;
        if (old != null) {
            old.func_231164_f_();
        }
        minecraft.field_71462_r = screen;
        minecraft.field_71417_B.func_198032_j();
        KeyBinding.func_74506_a();
        screen.func_231158_b_(minecraft, minecraft.func_228018_at_().func_198107_o(), minecraft.func_228018_at_().func_198087_p());
        minecraft.field_71454_w = false;
        NarratorChatListener.field_193643_a.func_216864_a(screen.func_231167_h_());
        minecraft.func_230150_b_();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AdvancementFrameBlockTile();
    }

    public static enum FrameType implements IStringSerializable
    {
        EMPTY("empty"),
        TASK("task"),
        GOAL("goal"),
        CHALLENGE("challenge");

        private final String name;

        private FrameType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static FrameType fromAdvancement(DisplayInfo advancement) {
            net.minecraft.advancements.FrameType type = advancement.func_192291_d();
            switch (type) {
                case GOAL: {
                    return GOAL;
                }
                default: {
                    return TASK;
                }
                case CHALLENGE: 
            }
            return CHALLENGE;
        }
    }
}

