/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.advframes.init.ModRegistry;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class AdvancementFrameBlockTile
extends TileEntity {
    private DisplayInfo advancement;
    private GameProfile owner;
    private static PlayerProfileCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;

    public AdvancementFrameBlockTile() {
        super((TileEntityType)ModRegistry.ADVANCEMENT_FRAME_TILE.get());
    }

    public void setAdvancement(Advancement advancement, ServerPlayerEntity player) {
        this.advancement = advancement.func_192068_c();
        this.setOwner(new GameProfile(player.func_110124_au(), null));
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(AdvancementFrameBlock.TYPE, (Comparable)((Object)AdvancementFrameBlock.FrameType.fromAdvancement(this.advancement))));
    }

    public CompoundNBT func_189515_b(CompoundNBT cmp) {
        super.func_189515_b(cmp);
        if (this.owner != null) {
            cmp.func_186854_a("PlayerID", this.owner.getId());
        }
        if (this.advancement != null) {
            CompoundNBT tag = new CompoundNBT();
            ITextComponent title = this.advancement.func_192297_a();
            if (title instanceof TranslationTextComponent) {
                tag.func_74778_a("Title", ((TranslationTextComponent)title).func_150268_i());
            } else {
                tag.func_74778_a("Title", title.getString());
            }
            ITextComponent description = this.advancement.func_193222_b();
            if (description instanceof TranslationTextComponent) {
                tag.func_74778_a("Description", ((TranslationTextComponent)description).func_150268_i());
            } else {
                tag.func_74778_a("Description", description.getString());
            }
            tag.func_218657_a("Icon", (INBT)this.advancement.func_192298_b().func_77955_b(new CompoundNBT()));
            tag.func_74768_a("FrameType", this.advancement.func_192291_d().ordinal());
            cmp.func_218657_a("Advancement", (INBT)tag);
        }
        return cmp;
    }

    public void func_230337_a_(BlockState state, CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        if (cmp.func_74764_b("PlayerID")) {
            UUID id = cmp.func_186857_a("PlayerID");
            this.setOwner(new GameProfile(id, null));
        }
        if (cmp.func_74764_b("Advancement")) {
            CompoundNBT tag = cmp.func_74775_l("Advancement");
            TranslationTextComponent title = new TranslationTextComponent(tag.func_74779_i("Title"));
            TranslationTextComponent description = new TranslationTextComponent(tag.func_74779_i("Description"));
            ItemStack icon = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Icon"));
            FrameType type = FrameType.values()[tag.func_74762_e("FrameType")];
            this.advancement = new DisplayInfo(icon, (ITextComponent)title, (ITextComponent)description, null, type, false, true, true);
        }
    }

    public TextFormatting getColor() {
        FrameType v = this.getAdvancement().func_192291_d();
        if (v == FrameType.GOAL) {
            return TextFormatting.AQUA;
        }
        return v.func_193229_c();
    }

    public DisplayInfo getAdvancement() {
        return this.advancement;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile input) {
        if (!(this.owner != null || input != null && input.isComplete())) {
            AdvancementFrameBlockTile advancementFrameBlockTile = this;
            synchronized (advancementFrameBlockTile) {
                this.owner = input;
            }
            AdvancementFrameBlockTile.updateGameProfile(this.owner, gameProfile -> {
                this.owner = gameProfile;
            });
        }
    }

    public static void updateGameProfile(@Nullable GameProfile gameProfile, Consumer<GameProfile> consumer) {
        if (!(gameProfile == null || gameProfile.getId() == null || gameProfile.isComplete() && gameProfile.getName() != null || profileCache == null || sessionService == null)) {
            Optional<GameProfile> profile = Optional.ofNullable(profileCache.func_152652_a(gameProfile.getId()));
            Util.func_215072_e().execute(() -> Util.func_215077_a((Optional)profile, p -> {
                if (p.getName() == null) {
                    p = sessionService.fillProfileProperties(p, true);
                }
                GameProfile finalGp = p;
                mainThreadExecutor.execute(() -> {
                    profileCache.func_152649_a(finalGp);
                    consumer.accept(finalGp);
                });
            }, () -> mainThreadExecutor.execute(() -> consumer.accept(gameProfile))));
        } else {
            consumer.accept(gameProfile);
        }
    }

    public static void setup(PlayerProfileCache p_196701_, MinecraftSessionService p_196702_, Executor p_196703_) {
        profileCache = p_196701_;
        sessionService = p_196702_;
        mainThreadExecutor = p_196703_;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }
}

