/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerBoundSetAdvancementFramePacket {
    private final BlockPos pos;
    public final ResourceLocation advancementId;

    public ServerBoundSetAdvancementFramePacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.advancementId = buf.func_192575_l();
    }

    public ServerBoundSetAdvancementFramePacket(BlockPos pos, Advancement advancement) {
        this.pos = pos;
        this.advancementId = advancement.func_192067_g();
    }

    public static void buffer(ServerBoundSetAdvancementFramePacket message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_192572_a(message.advancementId);
    }

    public static void handler(ServerBoundSetAdvancementFramePacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = Objects.requireNonNull(ctx.get().getSender());
        ctx.get().enqueueWork(() -> {
            Advancement advancement;
            BlockPos pos;
            ServerWorld level = player.func_71121_q();
            TileEntity tile = level.func_175625_s(pos = message.pos);
            if (tile instanceof AdvancementFrameBlockTile && (advancement = level.func_73046_m().func_191949_aK().func_192778_a(message.advancementId)) != null) {
                ((AdvancementFrameBlockTile)tile).setAdvancement(advancement, player);
                BlockState state = level.func_180495_p(pos);
                level.func_184138_a(pos, state, state, 3);
                tile.func_70296_d();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

