/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.mehvahdjukaar.advframes.init.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancementFrameBlockTile
extends BlockEntity {
    private String advancementId = null;
    private DisplayInfo advancement;
    private GameProfile owner;
    private static GameProfileCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;

    public AdvancementFrameBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.ADVANCEMENT_FRAME_TILE.get(), pos, state);
    }

    public void setAdvancement(Advancement advancement, ServerPlayer player) {
        this.advancement = advancement.m_138320_();
        this.advancementId = advancement.m_138327_().toString();
        this.setOwner(new GameProfile(player.m_142081_(), null));
    }

    protected void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        if (this.advancement != null) {
            Component title;
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (this.owner != null && this.advancementId != null && !this.advancementId.isEmpty()) {
                    ServerPlayer sp;
                    Advancement a = server.m_142572_().m_129889_().m_136041_(new ResourceLocation(this.advancementId));
                    Player player = this.f_58857_.m_46003_(this.owner.getId());
                    if (a == null || player instanceof ServerPlayer && !(sp = (ServerPlayer)player).m_8960_().m_135996_(a).m_8193_()) {
                        return;
                    }
                }
            }
            CompoundTag tag = new CompoundTag();
            if (this.advancementId != null) {
                cmp.m_128359_("ID", this.advancementId);
            }
            if ((title = this.advancement.m_14977_()) instanceof TranslatableComponent) {
                TranslatableComponent translatableComponent = (TranslatableComponent)title;
                tag.m_128359_("Title", translatableComponent.m_131328_());
            } else {
                tag.m_128359_("Title", title.getString());
            }
            Component description = this.advancement.m_14985_();
            if (description instanceof TranslatableComponent) {
                TranslatableComponent translatableComponent = (TranslatableComponent)description;
                tag.m_128359_("Description", translatableComponent.m_131328_());
            } else {
                tag.m_128359_("Description", description.getString());
            }
            tag.m_128365_("Icon", (Tag)this.advancement.m_14990_().m_41739_(new CompoundTag()));
            tag.m_128405_("FrameType", this.advancement.m_14992_().ordinal());
            cmp.m_128365_("Advancement", (Tag)tag);
        }
        if (this.owner != null) {
            cmp.m_128362_("PlayerID", this.owner.getId());
        }
    }

    public void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        this.advancementId = null;
        if (cmp.m_128441_("PlayerID")) {
            UUID id = cmp.m_128342_("PlayerID");
            this.setOwner(new GameProfile(id, null));
        }
        if (cmp.m_128441_("Advancement")) {
            CompoundTag tag = cmp.m_128469_("Advancement");
            if (cmp.m_128441_("ID")) {
                this.advancementId = tag.m_128461_("ID");
            }
            TranslatableComponent title = new TranslatableComponent(tag.m_128461_("Title"));
            TranslatableComponent description = new TranslatableComponent(tag.m_128461_("Description"));
            ItemStack icon = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Icon"));
            FrameType type = FrameType.values()[tag.m_128451_("FrameType")];
            this.advancement = new DisplayInfo(icon, (Component)title, (Component)description, null, type, false, true, true);
        }
    }

    public ChatFormatting getColor() {
        FrameType v = this.getAdvancement().m_14992_();
        if (v == FrameType.GOAL) {
            return ChatFormatting.AQUA;
        }
        return v.m_15552_();
    }

    public DisplayInfo getAdvancement() {
        return this.advancement;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.advancement != null) {
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }
        return null;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile input) {
        if (!(this.owner != null || input != null && input.isComplete())) {
            AdvancementFrameBlockTile advancementFrameBlockTile = this;
            synchronized (advancementFrameBlockTile) {
                this.owner = input;
            }
            AdvancementFrameBlockTile.updateGameProfile(this.owner, gameProfile -> {
                this.owner = gameProfile;
            });
        }
    }

    public static void updateGameProfile(@Nullable GameProfile gameProfile, Consumer<GameProfile> consumer) {
        if (!(gameProfile == null || gameProfile.getId() == null || gameProfile.isComplete() && gameProfile.getName() != null || profileCache == null || sessionService == null)) {
            Optional profile = profileCache.m_11002_(gameProfile.getId());
            Util.m_183991_().execute(() -> Util.m_137521_((Optional)profile, p -> {
                if (p.getName() == null) {
                    p = sessionService.fillProfileProperties(p, true);
                }
                GameProfile finalGp = p;
                mainThreadExecutor.execute(() -> {
                    profileCache.m_10991_(finalGp);
                    consumer.accept(finalGp);
                });
            }, () -> mainThreadExecutor.execute(() -> consumer.accept(gameProfile))));
        } else {
            consumer.accept(gameProfile);
        }
    }

    public static void setup(GameProfileCache p_196701_, MinecraftSessionService p_196702_, Executor p_196703_) {
        profileCache = p_196701_;
        sessionService = p_196702_;
        mainThreadExecutor = p_196703_;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }
}

