/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSetAdvancementFramePacket {
    private final BlockPos pos;
    public final ResourceLocation advancementId;

    public ServerBoundSetAdvancementFramePacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.advancementId = buf.m_130281_();
    }

    public ServerBoundSetAdvancementFramePacket(BlockPos pos, Advancement advancement) {
        this.pos = pos;
        this.advancementId = advancement.m_138327_();
    }

    public static void buffer(ServerBoundSetAdvancementFramePacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130085_(message.advancementId);
    }

    public static void handler(ServerBoundSetAdvancementFramePacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = Objects.requireNonNull(ctx.get().getSender());
        ctx.get().enqueueWork(() -> {
            ServerLevel level = (ServerLevel)player.f_19853_;
            BlockPos pos = message.pos;
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof AdvancementFrameBlockTile) {
                AdvancementFrameBlockTile te = (AdvancementFrameBlockTile)tile;
                Advancement advancement = level.m_142572_().m_129889_().m_136041_(message.advancementId);
                if (advancement != null) {
                    te.setAdvancement(advancement, player);
                    BlockState state = level.m_8055_(pos);
                    level.m_7260_(pos, state, state, 3);
                    tile.m_6596_();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

