/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set;

import java.util.Optional;
import net.mehvahdjukaar.selene.client.asset_generators.LangBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public interface IBlockType {
    public ResourceLocation getId();

    public String toString();

    public String getTypeName();

    public String getNamespace();

    public String getTranslationKey();

    default public String getVariantId(String baseName) {
        return this.getVariantId(baseName, true);
    }

    default public String getVariantId(String baseName, boolean prefix) {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return baseName + "_" + this.getTypeName();
        }
        return prefix ? namespace + "/" + baseName + "_" + this.getTypeName() : namespace + "/" + this.getTypeName() + "_" + baseName;
    }

    default public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    default public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    @Nullable
    default public <V extends IForgeRegistryEntry<V>> V findRelatedEntry(String appendedName, IForgeRegistry<V> reg) {
        return this.findRelatedEntry(appendedName, "", reg);
    }

    @Nullable
    default public <V extends IForgeRegistryEntry<V>> V findRelatedEntry(String append, String postpend, IForgeRegistry<V> reg) {
        Object post = postpend.isEmpty() ? "" : "_" + postpend;
        ResourceLocation id = this.getId();
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + (String)post), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_planks_" + append + (String)post)};
        IForgeRegistryEntry found = null;
        for (ResourceLocation r : targets) {
            if (!reg.containsKey(r)) continue;
            found = reg.getValue(r);
            break;
        }
        return (V)found;
    }

    public static abstract class SetFinder<T extends IBlockType> {
        public abstract Optional<T> get();
    }
}

