/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set.wood;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WoodType
implements IBlockType {
    public static WoodType OAK_WOOD_TYPE = new WoodType(new ResourceLocation("oak"), Blocks.f_50705_, Blocks.f_49999_);
    public final ResourceLocation id;
    public final Material material;
    public final Block planks;
    public final Block log;
    @Nullable
    public final Block slab;
    @Nullable
    public final Block stairs;
    @Nullable
    public final Block fence;
    @Nullable
    public final Block fenceGate;
    @Nullable
    public final Block button;
    @Nullable
    public final Block pressurePlate;
    @Nullable
    public final Block door;
    @Nullable
    public final Block trapdoor;
    @Nullable
    public final Block strippedLog;
    @Nullable
    public final Block strippedWood;
    @Nullable
    public final Block wood;
    @Nullable
    public final Block leaves;
    public final Lazy<Item> signItem;
    public final Lazy<Item> boatItem;
    @Nullable
    private final net.minecraft.world.level.block.state.properties.WoodType vanillaType;
    public final String shortenedNamespace;

    protected WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        this.id = id;
        this.planks = baseBlock;
        this.log = logBlock;
        this.material = baseBlock.m_49966_().m_60767_();
        this.shortenedNamespace = id.m_135827_().equals("minecraft") ? "" : "_" + WoodType.abbreviateString(id.m_135827_());
        this.leaves = (Block)this.findRelatedEntry("leaves", ForgeRegistries.BLOCKS);
        this.strippedLog = (Block)this.findRelatedEntry("stripped", "log", ForgeRegistries.BLOCKS);
        this.strippedWood = (Block)this.findRelatedEntry("stripped", "wood", ForgeRegistries.BLOCKS);
        this.wood = (Block)this.findRelatedEntry("wood", ForgeRegistries.BLOCKS);
        this.slab = (Block)this.findRelatedEntry("slab", ForgeRegistries.BLOCKS);
        this.stairs = (Block)this.findRelatedEntry("stairs", ForgeRegistries.BLOCKS);
        this.fence = (Block)this.findRelatedEntry("fence", ForgeRegistries.BLOCKS);
        this.fenceGate = (Block)this.findRelatedEntry("fence_gate", ForgeRegistries.BLOCKS);
        this.door = (Block)this.findRelatedEntry("door", ForgeRegistries.BLOCKS);
        this.trapdoor = (Block)this.findRelatedEntry("trapdoor", ForgeRegistries.BLOCKS);
        this.button = (Block)this.findRelatedEntry("button", ForgeRegistries.BLOCKS);
        this.pressurePlate = (Block)this.findRelatedEntry("pressure_plate", ForgeRegistries.BLOCKS);
        this.signItem = Lazy.of(() -> (Item)this.findRelatedEntry("sign", ForgeRegistries.ITEMS));
        this.boatItem = Lazy.of(() -> (Item)this.findRelatedEntry("boat", ForgeRegistries.ITEMS));
        String i = id.m_135827_().equals("minecraft") ? "" : id.m_135827_() + "/" + id.m_135815_();
        Optional<net.minecraft.world.level.block.state.properties.WoodType> o = net.minecraft.world.level.block.state.properties.WoodType.m_61843_().filter(v -> v.m_61846_().equals(i)).findAny();
        this.vanillaType = o.orElse(null);
    }

    @Nullable
    public net.minecraft.world.level.block.state.properties.WoodType toVanilla() {
        return this.vanillaType;
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    @Deprecated
    public String getWoodName() {
        return this.getTypeName();
    }

    @Override
    public String getTypeName() {
        return this.id.m_135815_();
    }

    @Override
    public String getNamespace() {
        return this.id.m_135827_();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Deprecated
    public String getAppendableId() {
        return this.getTypeName() + this.shortenedNamespace;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.material.m_76335_();
    }

    public MaterialColor getColor() {
        return this.material.m_76339_();
    }

    @Deprecated
    private static String abbreviateString(String string) {
        if (string.length() <= 5) {
            return string;
        }
        String[] a = string.split("_");
        if (a.length > 2) {
            return "" + a[0].charAt(0) + a[1].charAt(0) + a[2].charAt(0) + (Serializable)(a.length > 3 ? Character.valueOf(a[3].charAt(0)) : "");
        }
        if (a.length > 1) {
            return a[0].substring(0, Math.min(2, a[0].length())) + a[1].substring(0, Math.min(2, a[0].length()));
        }
        return string.substring(0, 4);
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getTypeName().replace("/", ".");
    }

    public static class Finder
    extends IBlockType.SetFinder<WoodType> {
        private final Supplier<Block> planksFinder;
        private final Supplier<Block> logFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new ResourceLocation(modId, woodTypeName), new ResourceLocation(modId, planksName), new ResourceLocation(modId, logName));
        }

        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)ForgeRegistries.BLOCKS.getValue(planksName), () -> (Block)ForgeRegistries.BLOCKS.getValue(logName));
        }

        @Override
        public Optional<WoodType> get() {
            if (ModList.get().isLoaded(this.id.m_135827_())) {
                try {
                    Block plank = this.planksFinder.get();
                    Block log = this.logFinder.get();
                    Block d = (Block)ForgeRegistries.BLOCKS.getValue(ForgeRegistries.BLOCKS.getDefaultKey());
                    if (plank != d && log != d && plank != null && log != null) {
                        return Optional.of(new WoodType(this.id, plank, log));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Selene.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

