/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.client.asset_generators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.mehvahdjukaar.selene.resourcepack.DynamicLanguageManager;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class LangBuilder {
    private final Map<String, String> entries = new LinkedHashMap<String, String>();

    public static String getReadableName(String name) {
        return Arrays.stream(name.replace(":", "_").split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static Component getReadableComponent(String key, String ... arguments) {
        TranslatableComponent translated = new TranslatableComponent(key, (Object[])arguments);
        if (translated.getString().equals(key)) {
            StringBuilder aa = new StringBuilder();
            for (String s : arguments) {
                aa.append("_").append(s);
            }
            return new TextComponent(LangBuilder.getReadableName(key + aa));
        }
        return translated;
    }

    public void addGenericEntry(String key, String translation) {
        this.entries.put(key, translation);
    }

    public void addEntry(Block block, String translation) {
        this.entries.put(block.m_7705_(), translation);
    }

    public <T extends ForgeRegistryEntry<V>, V extends IForgeRegistryEntry<V>> void addEntry(Registry<T> reg, T entry, String translation) {
        this.entries.put(Util.m_137492_((String)reg.m_123023_().getRegistryName().m_135815_(), (ResourceLocation)reg.m_7981_(entry)), translation);
    }

    public <T extends ForgeRegistryEntry<V>, V extends IForgeRegistryEntry<V>> void addSimpleEntry(Registry<T> reg, T entry) {
        this.entries.put(Util.m_137492_((String)reg.m_123023_().getRegistryName().m_135815_(), (ResourceLocation)reg.m_7981_(entry)), LangBuilder.getReadableName(entry.getRegistryName().m_135815_()));
    }

    public void addEntry(Item item, String translation) {
        this.entries.put(item.m_5524_(), translation);
    }

    public void addEntry(EntityType<?> entityType, String translation) {
        this.entries.put(entityType.m_20675_(), translation);
    }

    public JsonElement build() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, String> e : this.entries.entrySet()) {
            json.addProperty(e.getKey(), e.getValue());
        }
        return json;
    }

    public Map<String, String> entries() {
        return this.entries;
    }

    public static void addDynamicEntry(DynamicLanguageManager.LanguageAccessor lang, String key, IBlockType type, Item item) {
        String typeName;
        String base = lang.getEntry(key);
        if (base != null && (typeName = lang.getEntry(type.getTranslationKey())) != null) {
            lang.addEntry(item.m_5524_(), String.format(base, typeName));
        }
    }

    public static void addDynamicEntry(DynamicLanguageManager.LanguageAccessor lang, String key, IBlockType type, Block block) {
        String typeName;
        String base = lang.getEntry(key);
        if (base != null && (typeName = lang.getEntry(type.getTranslationKey())) != null) {
            lang.addEntry(block.m_7705_(), String.format(base, typeName));
        }
    }

    public static void addDynamicEntry(DynamicLanguageManager.LanguageAccessor lang, String key, IBlockType type, EntityType<?> entityType) {
        String typeName;
        String base = lang.getEntry(key);
        if (base != null && (typeName = lang.getEntry(type.getTranslationKey())) != null) {
            lang.addEntry(entityType.m_20675_(), String.format(base, typeName));
        }
    }
}

