/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDataHolder;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.markers.MapBlockMarker;
import net.minecraft.core.BlockPos;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapDecorationHandler {
    public static final Map<String, CustomDataHolder<?>> CUSTOM_MAP_DATA_TYPES = new HashMap();
    private static final Map<String, CustomDecorationType<? extends CustomDecoration, ?>> DECORATION_TYPES = new HashMap();
    public static final CustomDecorationType<CustomDecoration, ?> GENERIC_STRUCTURE_TYPE = MapDecorationHandler.makeSimpleType("selene", "generic_structure");

    public static <T extends CustomDecoration> void register(CustomDecorationType<T, ?> newType) {
        String id = newType.getRegistryId();
        if (DECORATION_TYPES.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate map decoration registration " + id);
        }
        DECORATION_TYPES.put(id, newType);
    }

    public static void registerSimple(String modId, String name) {
        MapDecorationHandler.register(MapDecorationHandler.makeSimpleType(modId, name));
    }

    public static CustomDecorationType<CustomDecoration, ?> makeSimpleType(String modId, String name) {
        return new CustomDecorationType(new ResourceLocation(modId, name), CustomDecoration::new);
    }

    @Nullable
    public static CustomDecorationType<?, ?> get(ResourceLocation id) {
        return MapDecorationHandler.get(id.toString());
    }

    @Nullable
    public static CustomDecorationType<? extends CustomDecoration, ?> get(String id) {
        return DECORATION_TYPES.get(id);
    }

    @Nullable
    public static MapBlockMarker<?> readWorldMarker(CompoundTag compound) {
        for (String s : DECORATION_TYPES.keySet()) {
            if (!compound.m_128441_(s)) continue;
            return DECORATION_TYPES.get(s).loadMarkerFromNBT(compound.m_128469_(s));
        }
        return null;
    }

    public static List<MapBlockMarker<?>> getMarkersFromWorld(BlockGetter reader, BlockPos pos) {
        ArrayList list = new ArrayList();
        for (CustomDecorationType<CustomDecoration, ?> type : DECORATION_TYPES.values()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapBlockMarker<?>)c);
        }
        return list;
    }

    public static void addTargetDecoration(ItemStack stack, BlockPos pos, CustomDecorationType<?, ?> type, int mapColor) {
        ListTag listnbt;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("CustomDecorations", 9)) {
            listnbt = stack.m_41783_().m_128437_("CustomDecorations", 10);
        } else {
            listnbt = new ListTag();
            stack.m_41700_("CustomDecorations", (Tag)listnbt);
        }
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("type", type.getRegistryId());
        compoundnbt.m_128405_("x", pos.m_123341_());
        compoundnbt.m_128405_("z", pos.m_123343_());
        listnbt.add((Object)compoundnbt);
        if (mapColor != 0) {
            CompoundTag com = stack.m_41698_("display");
            com.m_128405_("MapColor", mapColor);
        }
    }

    public static void addVanillaTargetDecorations(ItemStack stack, BlockPos pos, MapDecoration.Type type, int mapColor) {
        MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)type);
        if (mapColor != 0) {
            CompoundTag com = stack.m_41698_("display");
            com.m_128405_("MapColor", mapColor);
        }
    }

    public static void addTargetDecoration(ItemStack stack, BlockPos pos, ResourceLocation id, int mapColor) {
        Optional<MapDecoration.Type> opt;
        if (id.m_135827_().equals("minecraft") && (opt = Arrays.stream(MapDecoration.Type.values()).filter(t -> t.toString().toLowerCase().equals(id.m_135815_())).findFirst()).isPresent()) {
            MapDecorationHandler.addVanillaTargetDecorations(stack, pos, opt.get(), mapColor);
            return;
        }
        CustomDecorationType<CustomDecoration, ?> type = DECORATION_TYPES.getOrDefault(id.toString(), GENERIC_STRUCTURE_TYPE);
        MapDecorationHandler.addTargetDecoration(stack, pos, type, mapColor);
    }

    public static <T> void registerCustomMapSavedData(String name, Class<T> type, Function<CompoundTag, T> load, BiConsumer<CompoundTag, T> save, PropertyDispatch.TriFunction<MapItemSavedData, Entity, T, Boolean> onItemUpdate, PropertyDispatch.TriFunction<MapItemSavedData, ItemStack, T, Component> onItemTooltip) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey("name")) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + name);
        }
        CUSTOM_MAP_DATA_TYPES.put(name, new CustomDataHolder<T>(name, load, save, onItemUpdate, onItemTooltip));
    }
}

